/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import io.debezium.outbox.quarkus.it.AbstractOutboxTest;
import io.debezium.outbox.quarkus.it.DatabaseTestResource;
import io.debezium.outbox.quarkus.it.OutboxProfiles;
import io.debezium.outbox.quarkus.it.TestAsserts;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=OutboxProfiles.OpenTelemetryDisabled.class)
@QuarkusTestResource(value=DatabaseTestResource.class)
public class OutboxWithoutOpenTelemetryTest
extends AbstractOutboxTest {
    @Test
    public void testOutboxEntityMetamodelDoesntHaveTracingSpanColumn() throws Exception {
        MappingMetamodelImplementor metadata = ((SessionImplementor)this.entityManager.unwrap(SessionImplementor.class)).getFactory().getMappingMetamodel();
        EntityPersister persister = metadata.getEntityDescriptor("io.debezium.outbox.quarkus.internal.OutboxEvent");
        Assertions.assertNotNull((Object)persister);
        TestAsserts.assertIsType(persister, String.class, "aggregateType");
        TestAsserts.assertHasNoMapping(persister, "tracingspancontext");
    }
}

