/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import io.debezium.outbox.quarkus.it.DatabaseTestResource;
import io.debezium.outbox.quarkus.it.MyService;
import io.debezium.outbox.quarkus.it.TestAsserts;
import io.quarkus.test.common.QuarkusTestResource;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTestResource(value=DatabaseTestResource.class)
public abstract class AbstractOutboxTest {
    @Inject
    EntityManager entityManager;
    @Inject
    MyService myService;

    @Test
    public void testOutboxEntityMetamodelExists() throws Exception {
        MappingMetamodelImplementor metadata = ((SessionImplementor)this.entityManager.unwrap(SessionImplementor.class)).getFactory().getMappingMetamodel();
        EntityPersister persister = metadata.findEntityDescriptor("io.debezium.outbox.quarkus.internal.OutboxEvent");
        Assertions.assertNotNull((Object)persister);
        Assertions.assertEquals(UUID.class, (Object)persister.getIdentifierType().getReturnedClass());
        TestAsserts.assertIsType(persister, String.class, "aggregateType");
        TestAsserts.assertIsType(persister, Long.class, "aggregateId");
        TestAsserts.assertIsType(persister, String.class, "type");
        TestAsserts.assertIsType(persister, Instant.class, "timestamp");
        TestAsserts.assertIsType(persister, String.class, "payload");
        TestAsserts.assertIsType(persister, String.class, "name");
        TestAsserts.assertIsType(persister, String.class, "name_upper");
        TestAsserts.assertIsType(persister, String.class, "name_no_columndef");
    }

    @Test
    public void firedEventGetsPersistedInOutboxTable() {
        this.myService.doSomething();
        Map row = (Map)this.entityManager.createQuery("FROM OutboxEvent").getSingleResult();
        Assertions.assertNotNull(row.get("id"));
        Assertions.assertEquals((Object)1L, row.get("aggregateId"));
        Assertions.assertEquals((Object)"MyOutboxEvent", row.get("aggregateType"));
        Assertions.assertEquals((Object)"SomeType", row.get("type"));
        Assertions.assertTrue((boolean)((Instant)row.get("timestamp")).isBefore(Instant.now()));
        Assertions.assertEquals((Object)"Some amazing payload", row.get("payload"));
        Assertions.assertEquals((Object)"John Doe", row.get("name"));
        Assertions.assertEquals((Object)"JOHN DOE", row.get("name_upper"));
        Assertions.assertEquals((Object)"Jane Doe", row.get("name_no_columndef"));
    }
}

