/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import io.debezium.outbox.quarkus.it.AbstractOutboxTest;
import io.debezium.outbox.quarkus.it.MyService;
import io.debezium.outbox.quarkus.it.OutboxProfiles;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.time.Instant;
import java.util.Map;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=OutboxProfiles.Default.class)
public class OutboxTest
extends AbstractOutboxTest {
    @Inject
    EntityManager entityManager;
    @Inject
    MyService myService;

    @Override
    @Test
    public void firedEventGetsPersistedInOutboxTable() {
        this.myService.doSomething();
        Map row = (Map)this.entityManager.createQuery("FROM OutboxEvent").getSingleResult();
        Assertions.assertNotNull(row.get("id"));
        Assertions.assertEquals((Object)1L, row.get("aggregateId"));
        Assertions.assertEquals((Object)"MyOutboxEvent", row.get("aggregateType"));
        Assertions.assertEquals((Object)"SomeType", row.get("type"));
        Assertions.assertTrue((boolean)((Instant)row.get("timestamp")).isBefore(Instant.now()));
        Assertions.assertEquals((Object)"Some amazing payload", row.get("payload"));
        Assertions.assertNotNull(row.get("tracingspancontext"));
    }
}

