/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import io.debezium.outbox.quarkus.it.DatabaseTestResource;
import io.debezium.outbox.quarkus.it.MyService;
import io.quarkus.test.common.QuarkusTestResource;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTestResource(value=DatabaseTestResource.class)
public abstract class AbstractOutboxTest {
    @Inject
    EntityManager entityManager;
    @Inject
    MyService myService;

    @Test
    public void testOutboxEntityMetamodelExists() throws Exception {
        MetamodelImplementor metadata = ((SessionImplementor)this.entityManager.unwrap(SessionImplementor.class)).getFactory().getMetamodel();
        EntityPersister persister = metadata.entityPersister("io.debezium.outbox.quarkus.internal.OutboxEvent");
        Assertions.assertNotNull((Object)persister);
        Assertions.assertEquals(UUID.class, (Object)persister.getIdentifierType().getReturnedClass());
        Assertions.assertEquals(String.class, (Object)persister.getPropertyType("aggregateType").getReturnedClass());
        Assertions.assertEquals(Long.class, (Object)persister.getPropertyType("aggregateId").getReturnedClass());
        Assertions.assertEquals(String.class, (Object)persister.getPropertyType("type").getReturnedClass());
        Assertions.assertEquals(Instant.class, (Object)persister.getPropertyType("timestamp").getReturnedClass());
        Assertions.assertEquals(String.class, (Object)persister.getPropertyType("payload").getReturnedClass());
    }

    @Test
    public void firedEventGetsPersistedInOutboxTable() {
        this.myService.doSomething();
        Map row = (Map)this.entityManager.createQuery("FROM OutboxEvent").getSingleResult();
        Assertions.assertNotNull(row.get("id"));
        Assertions.assertEquals((Object)1L, row.get("aggregateId"));
        Assertions.assertEquals((Object)"MyOutboxEvent", row.get("aggregateType"));
        Assertions.assertEquals((Object)"SomeType", row.get("type"));
        Assertions.assertTrue((boolean)((Instant)row.get("timestamp")).isBefore(Instant.now()));
        Assertions.assertEquals((Object)"Some amazing payload", row.get("payload"));
    }
}

