/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import io.debezium.outbox.quarkus.it.AbstractOutboxTest;
import io.debezium.outbox.quarkus.it.MyService;
import io.debezium.outbox.quarkus.it.OutboxProfiles;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.UUID;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=OutboxProfiles.Default.class)
public class OutboxTest
extends AbstractOutboxTest {
    @Inject
    EntityManager entityManager;
    @Inject
    MyService myService;

    @Override
    @Test
    public void firedEventGetsPersistedInOutboxTable() {
        this.myService.doSomething();
        Query q = this.entityManager.createNativeQuery("SELECT CAST(id as varchar), aggregateId, aggregateType, type, timestamp, payload, tracingspancontext FROM OutboxEvent");
        Object[] row = (Object[])q.getSingleResult();
        Assertions.assertNotNull((Object)UUID.fromString((String)row[0]));
        Assertions.assertEquals((Object)BigInteger.valueOf(1L), (Object)row[1]);
        Assertions.assertEquals((Object)"MyOutboxEvent", (Object)row[2]);
        Assertions.assertEquals((Object)"SomeType", (Object)row[3]);
        Assertions.assertTrue((boolean)((Timestamp)row[4]).toInstant().isBefore(Instant.now()));
        Assertions.assertEquals((Object)"Some amazing payload", (Object)row[5]);
        Assertions.assertNotNull((Object)row[6]);
    }
}

