/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class DatabaseTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final String POSTGRES_USER = "postgres";
    private static final String POSTGRES_PASSWORD = "postgres";
    private static final String POSTGRES_DBNAME = "postgres";
    private static final String POSTGRES_IMAGE = "debezium/postgres:9.6";
    private static final DockerImageName POSTGRES_DOCKER_IMAGE_NAME = DockerImageName.parse((String)"debezium/postgres:9.6").asCompatibleSubstituteFor("postgres");
    private static PostgreSQLContainer<?> container;

    public Map<String, String> start() {
        try {
            container = (PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(POSTGRES_DOCKER_IMAGE_NAME).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*database system is ready to accept connections.*", (int)2))).withUsername("postgres").withPassword("postgres").withDatabaseName("postgres").withEnv("POSTGRES_INITDB_ARGS", "-E UTF8")).withEnv("LANG", "en_US.utf8")).withStartupTimeout(Duration.ofSeconds(30L));
            container.start();
            return Collections.singletonMap("quarkus.datasource.jdbc.url", container.getJdbcUrl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (container != null) {
                container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

