/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import com.fasterxml.jackson.databind.JsonNode;
import io.debezium.outbox.quarkus.it.DatabaseTestResource;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.time.Instant;
import java.util.UUID;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.EntityPersister;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=DatabaseTestResource.class)
public class OutboxTest {
    @Inject
    EntityManager entityManager;

    @Test
    public void testOutboxEntityMetamodelExists() throws Exception {
        MetamodelImplementor metadata = ((SessionImplementor)this.entityManager.unwrap(SessionImplementor.class)).getFactory().getMetamodel();
        EntityPersister persister = metadata.entityPersister("io.debezium.outbox.quarkus.internal.OutboxEvent");
        Assertions.assertNotNull((Object)persister);
        Assert.assertEquals(UUID.class, (Object)persister.getIdentifierType().getReturnedClass());
        Assert.assertEquals(String.class, (Object)persister.getPropertyType("aggregateType").getReturnedClass());
        Assert.assertEquals(String.class, (Object)persister.getPropertyType("aggregateId").getReturnedClass());
        Assert.assertEquals(String.class, (Object)persister.getPropertyType("type").getReturnedClass());
        Assert.assertEquals(Instant.class, (Object)persister.getPropertyType("timestamp").getReturnedClass());
        Assert.assertEquals(JsonNode.class, (Object)persister.getPropertyType("payload").getReturnedClass());
    }
}

