/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.it;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class DatabaseTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final String POSTGRES_USER = "postgres";
    private static final String POSTGRES_PASSWORD = "postgres";
    private static final String POSTGRES_DBNAME = "postgres";
    private static final String POSTGRES_IMAGE = "debezium/postgres:9.6";
    private static final Integer POSTGRES_PORT = 5432;
    private GenericContainer container;

    public Map<String, String> start() {
        try {
            this.container = new FixedHostPortGenericContainer(POSTGRES_IMAGE).withFixedExposedPort(POSTGRES_PORT.intValue(), POSTGRES_PORT.intValue()).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*database system is ready to accept connections.*", (int)2)).withEnv("POSTGRES_USER", "postgres").withEnv("POSTGRES_PASSWORD", "postgres").withEnv("POSTGRES_DB", "postgres").withEnv("POSTGRES_INITDB_ARGS", "-E UTF8").withEnv("LANG", "en_US.utf8").withStartupTimeout(Duration.ofSeconds(30L));
            this.container.start();
            return Collections.emptyMap();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            if (this.container != null) {
                this.container.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

