/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.deployment;

import io.debezium.outbox.quarkus.deployment.DebeziumOutboxConfig;
import io.debezium.outbox.quarkus.deployment.OutboxEventEntityBuildItem;
import io.debezium.outbox.quarkus.internal.JsonNodeAttributeConverter;
import java.util.UUID;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmBasicAttributeType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmColumnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmGeneratorSpecificationType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmIdentifierGeneratorDefinitionType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmRootEntityType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSimpleIdType;
import org.jboss.logging.Logger;

public class OutboxEventHbmWriter {
    private static final Logger LOGGER = Logger.getLogger(OutboxEventHbmWriter.class);
    private static final String JACKSON_JSONNODE = "com.fasterxml.jackson.databind.JsonNode";

    static JaxbHbmHibernateMapping write(DebeziumOutboxConfig config, OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        JaxbHbmHibernateMapping mapping = new JaxbHbmHibernateMapping();
        JaxbHbmRootEntityType entityType = new JaxbHbmRootEntityType();
        entityType.setEntityName("io.debezium.outbox.quarkus.internal.OutboxEvent");
        entityType.setTable(config.tableName);
        mapping.getClazz().add(entityType);
        JaxbHbmIdentifierGeneratorDefinitionType generatorType = new JaxbHbmIdentifierGeneratorDefinitionType();
        generatorType.setName("uuid2");
        generatorType.setClazz("uuid2");
        mapping.getIdentifierGenerator().add(generatorType);
        entityType.setId(OutboxEventHbmWriter.createIdAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createAggregateTypeAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createAggregateIdAttribute(config, outboxEventEntityBuildItem));
        entityType.getAttributes().add(OutboxEventHbmWriter.createTypeAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createTimestampAttribute(config));
        entityType.getAttributes().add(OutboxEventHbmWriter.createPayloadAttribute(config, outboxEventEntityBuildItem));
        if (config.tracingEnabled) {
            entityType.getAttributes().add(OutboxEventHbmWriter.createTracingSpanAttribute(config));
        }
        return mapping;
    }

    private static JaxbHbmSimpleIdType createIdAttribute(DebeziumOutboxConfig config) {
        JaxbHbmSimpleIdType attribute = new JaxbHbmSimpleIdType();
        attribute.setName("id");
        attribute.setTypeAttribute(UUID.class.getName());
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.id.name);
        config.id.columnDefinition.ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumn().add(column);
        JaxbHbmGeneratorSpecificationType generator = new JaxbHbmGeneratorSpecificationType();
        generator.setClazz("uuid2");
        attribute.setGenerator(generator);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createAggregateTypeAttribute(DebeziumOutboxConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("aggregateType");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.aggregateType.converter.isPresent()) {
            attribute.setTypeAttribute("converted::" + config.aggregateType.converter.get());
        } else {
            attribute.setTypeAttribute("string");
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.aggregateType.name);
        config.aggregateType.columnDefinition.ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createAggregateIdAttribute(DebeziumOutboxConfig config, OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("aggregateId");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.aggregateId.converter.isPresent()) {
            attribute.setTypeAttribute("converted::" + config.aggregateId.converter.get());
        } else {
            attribute.setTypeAttribute(outboxEventEntityBuildItem.getAggregateIdType().name().toString());
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.aggregateId.name);
        config.aggregateId.columnDefinition.ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createTypeAttribute(DebeziumOutboxConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("type");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.type.converter.isPresent()) {
            attribute.setTypeAttribute("converted::" + config.type.converter.get());
        } else {
            attribute.setTypeAttribute("string");
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.type.name);
        config.type.columnDefinition.ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createTimestampAttribute(DebeziumOutboxConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("timestamp");
        attribute.setNotNull(Boolean.valueOf(true));
        if (config.timestamp.converter.isPresent()) {
            attribute.setTypeAttribute("converted::" + config.timestamp.converter.get());
        } else {
            attribute.setTypeAttribute("Instant");
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.timestamp.name);
        config.timestamp.columnDefinition.ifPresent(arg_0 -> ((JaxbHbmColumnType)column).setSqlType(arg_0));
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createPayloadAttribute(DebeziumOutboxConfig config, OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        boolean isJacksonJsonNode = OutboxEventHbmWriter.isPayloadJacksonJsonNode(outboxEventEntityBuildItem);
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("payload");
        attribute.setNotNull(Boolean.valueOf(false));
        if (config.payload.type.isPresent()) {
            LOGGER.infof("Using payload type: %s", (Object)config.payload.type.get());
            attribute.setTypeAttribute(config.payload.type.get());
        } else if (config.payload.converter.isPresent()) {
            LOGGER.infof("Using payload attribute converter: %s", (Object)config.payload.converter.get());
            attribute.setTypeAttribute("converted::" + config.payload.converter.get());
        } else if (isJacksonJsonNode) {
            LOGGER.infof("Using payload attribute converter: %s", (Object)JsonNodeAttributeConverter.class.getName());
            attribute.setTypeAttribute("converted::" + JsonNodeAttributeConverter.class.getName());
        } else {
            String resolvedTypeName = outboxEventEntityBuildItem.getPayloadType().name().toString();
            LOGGER.infof("Using payload resolved type: %s", (Object)resolvedTypeName);
            attribute.setTypeAttribute(resolvedTypeName);
        }
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.payload.name);
        if (config.payload.columnDefinition.isPresent()) {
            column.setSqlType(config.payload.columnDefinition.get());
        } else if (isJacksonJsonNode) {
            column.setSqlType("varchar(8000)");
        }
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static JaxbHbmBasicAttributeType createTracingSpanAttribute(DebeziumOutboxConfig config) {
        JaxbHbmBasicAttributeType attribute = new JaxbHbmBasicAttributeType();
        attribute.setName("tracingspancontext");
        attribute.setNotNull(Boolean.valueOf(false));
        attribute.setTypeAttribute("string");
        JaxbHbmColumnType column = new JaxbHbmColumnType();
        column.setName(config.tracingSpan.name);
        column.setLength(Integer.valueOf(256));
        if (config.tracingSpan.columnDefinition.isPresent()) {
            column.setSqlType(config.tracingSpan.columnDefinition.get());
        }
        attribute.getColumnOrFormula().add(column);
        return attribute;
    }

    private static boolean isPayloadJacksonJsonNode(OutboxEventEntityBuildItem outboxEventEntityBuildItem) {
        return outboxEventEntityBuildItem.getPayloadType().name().toString().equals(JACKSON_JSONNODE);
    }
}

