/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.deployment;

import com.fasterxml.jackson.databind.JsonNode;
import io.debezium.outbox.quarkus.ExportedEvent;
import io.debezium.outbox.quarkus.deployment.DebeziumOutboxCommonConfig;
import io.debezium.outbox.quarkus.deployment.OutboxEventEntityBuildItem;
import io.debezium.outbox.quarkus.deployment.OutboxEventHbmWriter;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.hibernate.orm.deployment.PersistenceUnitDescriptorBuildItem;
import io.quarkus.hibernate.orm.deployment.integration.HibernateOrmIntegrationStaticConfiguredBuildItem;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OutboxCommonProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboxCommonProcessor.class);
    protected static final String DEBEZIUM_OUTBOX = "debezium-outbox";

    protected abstract DebeziumOutboxCommonConfig getConfig();

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem(DEBEZIUM_OUTBOX);
    }

    @BuildStep
    public void produceOutboxBuildItem(CombinedIndexBuildItem index, List<PersistenceUnitDescriptorBuildItem> persistenceUnitDescriptorBuildItems, BuildProducer<OutboxEventEntityBuildItem> outboxEventEntityProducer, BuildProducer<HibernateOrmIntegrationStaticConfiguredBuildItem> integrationConfiguredProducer) {
        DotName exportedEvent = DotName.createSimple((String)ExportedEvent.class.getName());
        Type aggregateIdType = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
        Type payloadType = Type.create((DotName)DotName.createSimple((String)JsonNode.class.getName()), (Type.Kind)Type.Kind.CLASS);
        boolean parameterizedTypesDetected = false;
        for (ClassInfo classInfo : index.getIndex().getAllKnownImplementors(exportedEvent)) {
            LOGGER.info("Found ExportedEvent type: {}", (Object)classInfo.name());
            for (Type interfaceType : classInfo.interfaceTypes()) {
                if (!interfaceType.name().equals((Object)exportedEvent)) continue;
                if (interfaceType.kind().equals((Object)Type.Kind.PARAMETERIZED_TYPE)) {
                    ParameterizedType pType = interfaceType.asParameterizedType();
                    if (pType.arguments().size() != 2) {
                        throw new IllegalArgumentException(String.format("Expected 2 parameterized types for class %s using interface ExportedEvent", classInfo.name()));
                    }
                    Type pTypeAggregateType = (Type)pType.arguments().get(0);
                    Type pTypePayloadType = (Type)pType.arguments().get(1);
                    LOGGER.debug(" * Implements ExportedEvent with generic parameters:");
                    LOGGER.debug("     AggregateId: {}", (Object)pTypeAggregateType.name().toString());
                    LOGGER.debug("     Payload: {}", (Object)pTypePayloadType.name().toString());
                    if (parameterizedTypesDetected) {
                        if (!pTypeAggregateType.equals((Object)aggregateIdType)) {
                            throw new IllegalStateException(String.format("Class %s implements ExportedEvent and expected aggregate-id parameter type to be %s but was %s. All ExportedEvent implementors must use the same parameter types.", classInfo.name(), aggregateIdType.name(), pTypeAggregateType.name()));
                        }
                        if (pTypePayloadType.equals((Object)payloadType)) continue;
                        throw new IllegalStateException(String.format("Class %s implements ExportedEvent and expected payload parameter type to be %s but was %s. All ExportedEvent implementors must use the same parameter types.", classInfo.name(), payloadType.name(), pTypePayloadType.name()));
                    }
                    aggregateIdType = pTypeAggregateType;
                    payloadType = pTypePayloadType;
                    parameterizedTypesDetected = true;
                    continue;
                }
                LOGGER.debug(" * Implements ExportedEvent without parameters, using:");
                LOGGER.debug("     AggregateId: {}", (Object)aggregateIdType.name().toString());
                LOGGER.debug("     Payload: {}", (Object)payloadType.name().toString());
            }
        }
        LOGGER.info("Binding Aggregate Id as '{}'.", (Object)aggregateIdType.name().toString());
        LOGGER.info("Binding Payload as '{}'.", (Object)payloadType.name().toString());
        outboxEventEntityProducer.produce((BuildItem)new OutboxEventEntityBuildItem(aggregateIdType, payloadType));
        for (PersistenceUnitDescriptorBuildItem puDescriptor : persistenceUnitDescriptorBuildItems) {
            integrationConfiguredProducer.produce((BuildItem)new HibernateOrmIntegrationStaticConfiguredBuildItem(DEBEZIUM_OUTBOX, puDescriptor.getPersistenceUnitName()).setXmlMappingRequired(true));
        }
    }

    protected void generateHbmMapping(OutboxEventEntityBuildItem outboxBuildItem, BuildProducer<GeneratedResourceBuildItem> generatedResourcesProducer) {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            JaxbHbmHibernateMapping jaxbMapping = OutboxEventHbmWriter.write(this.getConfig(), outboxBuildItem);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbHbmHibernateMapping.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            PrintWriter writer = new PrintWriter(os);
            marshaller.marshal((Object)jaxbMapping, (Writer)writer);
            LOGGER.debug("Outbox entity HBM mapping:\n{}", (Object)new String(os.toByteArray()));
            generatedResourcesProducer.produce((BuildItem)new GeneratedResourceBuildItem("META-INF/OutboxEvent.hbm.xml", os.toByteArray()));
        }
        catch (IOException | JAXBException e) {
            throw new IllegalStateException("Failed to produce Outbox HBM mapping", e);
        }
    }
}

