/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.DebeziumException;
import io.opentelemetry.context.propagation.TextMapSetter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public class DataMapTracingSetter
implements TextMapSetter<Map<String, Object>> {
    private DataMapTracingSetter() {
    }

    public static DataMapTracingSetter create() {
        return new DataMapTracingSetter();
    }

    public void set(@Nullable Map<String, Object> dataMap, @Nonnull String key, @Nonnull String value) {
        Properties props = new Properties();
        props.put(key, value);
        String context = DataMapTracingSetter.export(props);
        if (Objects.nonNull(dataMap)) {
            dataMap.put("tracingspancontext", context);
        }
    }

    private static String export(Properties props) {
        String string;
        StringWriter sw = new StringWriter();
        try {
            props.store(sw, null);
            string = ((Object)sw).toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Writer)sw).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new DebeziumException((Throwable)e);
            }
        }
        ((Writer)sw).close();
        return string;
    }
}

