/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.outbox.quarkus.internal;

import io.debezium.outbox.quarkus.ExportedEvent;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventWriter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventWriter.class);
    protected static final String TIMESTAMP = "timestamp";
    protected static final String PAYLOAD = "payload";
    protected static final String TYPE = "type";
    protected static final String AGGREGATE_ID = "aggregateId";
    protected static final String AGGREGATE_TYPE = "aggregateType";

    protected abstract T persist(Map<String, Object> var1);

    protected Map<String, Object> getDataMapFromEvent(ExportedEvent<?, ?> event) {
        Map<String, Object> dataMap = this.createDataMap(event);
        for (Map.Entry<String, Object> additionalFields : event.getAdditionalFieldValues().entrySet()) {
            if (dataMap.containsKey(additionalFields.getKey())) {
                LOGGER.error("Outbox entity already contains field with name '{}', additional field mapping skipped", (Object)additionalFields.getKey());
                continue;
            }
            dataMap.put(additionalFields.getKey(), additionalFields.getValue());
        }
        return dataMap;
    }

    protected Map<String, Object> createDataMap(ExportedEvent<?, ?> event) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(AGGREGATE_TYPE, event.getAggregateType());
        dataMap.put(AGGREGATE_ID, event.getAggregateId());
        dataMap.put(TYPE, event.getType());
        dataMap.put(PAYLOAD, event.getPayload());
        dataMap.put(TIMESTAMP, event.getTimestamp());
        return dataMap;
    }
}

