/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringUtils {
    public static final String EMPTY = "";

    public static String join(Map<String, ?> map, String kvSep, String sep) {
        return map.entrySet().stream().map(e -> StringUtils.joinEntry((String)e.getKey(), e.getValue(), kvSep)).collect(Collectors.joining(sep));
    }

    public static String joinAsJavaOpts(Map<String, ?> map) {
        return StringUtils.join(map, "=", " ");
    }

    public static Map<String, String> splitToMap(String input, String kvSep, String sep) {
        return Stream.of(input).filter(Predicate.not(String::isBlank)).map(i -> i.split(Pattern.quote(sep))).flatMap(Arrays::stream).map(elem -> StringUtils.splitEntry(elem, kvSep)).collect(HashMap::new, (m, v) -> m.put(v[0], v[1]), HashMap::putAll);
    }

    public static Map<String, String> splitJavaOpts(String input) {
        return StringUtils.splitToMap(input, "=", " ");
    }

    private static String[] splitEntry(String entry, String kvSep) {
        String[] result = new String[]{EMPTY, EMPTY};
        String[] keyValue = entry.split(Pattern.quote(kvSep), 2);
        System.arraycopy(keyValue, 0, result, 0, keyValue.length);
        return result;
    }

    private static String joinEntry(String key, Object value, String kvSep) {
        String valueAsString = String.valueOf(value);
        if (value == null || valueAsString.isEmpty()) {
            return key;
        }
        return key + kvSep + valueAsString;
    }

    private StringUtils() {
    }
}

