/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.config.ConfigMappable;
import io.debezium.operator.config.ConfigMapping;
import io.debezium.operator.model.Format;
import io.debezium.operator.model.Predicate;
import io.debezium.operator.model.Quarkus;
import io.debezium.operator.model.Runtime;
import io.debezium.operator.model.Sink;
import io.debezium.operator.model.Source;
import io.debezium.operator.model.Storage;
import io.debezium.operator.model.Transformation;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class DebeziumServerSpec
implements ConfigMappable {
    @JsonPropertyDescription(value="Image used for Debezium Server container. This property takes precedence over version.")
    private String image;
    @JsonPropertyDescription(value="Version of Debezium Server to be used.")
    private String version;
    @JsonPropertyDescription(value="Storage configuration to be used by this instance of Debezium Server.")
    private Storage storage = new Storage();
    @JsonPropertyDescription(value="Sink configuration.")
    private Sink sink = new Sink();
    @JsonPropertyDescription(value="Debezium source connector configuration.")
    private Source source = new Source();
    @JsonPropertyDescription(value="Message output format configuration.")
    private Format format = new Format();
    @JsonPropertyDescription(value="Quarkus configuration passed down to Debezium Server process.")
    private Quarkus quarkus = new Quarkus();
    @JsonPropertyDescription(value="Configuration allowing the modification of various aspects of Debezium Server runtime.")
    private Runtime runtime = new Runtime();
    @JsonPropertyDescription(value="Single Message Transformations employed by this instance of Debezium Server.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Transformation> transforms = List.of();
    @JsonPropertyDescription(value="Predicates employed by this instance of Debezium Server.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, Predicate> predicates = Map.of();

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public void setStorage(Storage storage) {
        this.storage = storage;
    }

    public Sink getSink() {
        return this.sink;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public Quarkus getQuarkus() {
        return this.quarkus;
    }

    public void setQuarkus(Quarkus quarkus) {
        this.quarkus = quarkus;
    }

    public Runtime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(Runtime runtime) {
        this.runtime = runtime;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public List<Transformation> getTransforms() {
        return this.transforms;
    }

    public void setTransforms(List<Transformation> transforms) {
        this.transforms = transforms;
    }

    public Map<String, Predicate> getPredicates() {
        return this.predicates;
    }

    public void setPredicates(Map<String, Predicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public ConfigMapping asConfiguration() {
        ConfigMapping dbzConfig = ConfigMapping.prefixed("debezium");
        dbzConfig.putAll("source", this.source);
        dbzConfig.putAll("sink", this.sink);
        dbzConfig.putAll("format", this.format);
        dbzConfig.putList("transforms", this.transforms, "t");
        dbzConfig.putMap("predicates", this.predicates);
        ConfigMapping config = ConfigMapping.empty();
        config.putAll("quarkus", this.quarkus);
        config.putAll(dbzConfig);
        return config;
    }
}

