/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.model;

import java.util.HashMap;
import java.util.Map;

public final class CommonLabels {
    public static final String KEY_APP_K8_INSTANCE = "app.kubernetes.io/instance";
    public static final String KEY_APP_K8_MANAGED_BY = "app.kubernetes.io/managed-by";
    public static final String KEY_APP_K8_COMPONENT = "app.kubernetes.io/component";
    public static final String KEY_DBZ_INSTANCE = "debezium.io/instance";
    public static final String KEY_DBZ_COMPONENT = "debezium.io/component";
    public static final String KEY_DBZ_CLASSIFIER = "debezium.io/classifier";
    private Map<String, String> map = new HashMap<String, String>();

    public static CommonLabels serverComponent(String instance) {
        return new CommonLabels().withManagedBy("debezium-operator").withComponent("DebeziumServer").withInstance(instance);
    }

    public CommonLabels withComponent(String component) {
        this.map.put(KEY_APP_K8_COMPONENT, component);
        this.map.put(KEY_DBZ_COMPONENT, component);
        return this;
    }

    public CommonLabels withInstance(String instance) {
        this.map.put(KEY_APP_K8_INSTANCE, instance);
        this.map.put(KEY_DBZ_INSTANCE, instance);
        return this;
    }

    public CommonLabels withManagedBy(String managedBy) {
        this.map.put(KEY_APP_K8_MANAGED_BY, managedBy);
        return this;
    }

    public CommonLabels withDbzClassifier(String classifier) {
        this.map.put(KEY_DBZ_CLASSIFIER, classifier);
        return this;
    }

    public Map<String, String> getMap() {
        return new HashMap<String, String>(this.map);
    }
}

