/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.dependent;

import io.debezium.operator.DebeziumServer;
import io.debezium.operator.dependent.discriminators.JmxServiceDiscriminator;
import io.debezium.operator.model.CommonLabels;
import io.debezium.operator.model.DebeziumServerSpec;
import io.debezium.operator.model.JmxConfig;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import java.util.Map;

@KubernetesDependent(resourceDiscriminator=JmxServiceDiscriminator.class)
public class JmxServiceDependent
extends CRUDKubernetesDependentResource<Service, DebeziumServer> {
    public static final String JMX_CLASSIFIER = "jmx";

    public JmxServiceDependent() {
        super(Service.class);
    }

    protected Service desired(DebeziumServer primary, Context<DebeziumServer> context) {
        JmxConfig jmxConfig = ((DebeziumServerSpec)primary.getSpec()).getRuntime().getJmx();
        String name = primary.getMetadata().getName();
        Map<String, String> labels = CommonLabels.serverComponent(name).withDbzClassifier(JMX_CLASSIFIER).getMap();
        Map<String, String> selector = CommonLabels.serverComponent(name).getMap();
        return ((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(primary.getMetadata().getNamespace())).withName(name + "-jmx")).withLabels(labels)).build())).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withSelector(selector)).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(JMX_CLASSIFIER)).withProtocol("TCP")).withTargetPort(new IntOrString((Object)jmxConfig.getPort()))).withPort(Integer.valueOf(jmxConfig.getPort()))).build()})).build())).build();
    }
}

