/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.util;

import io.debezium.operator.util.StringUtils;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class StringUtilTest {
    static final String EMPTY_PROP_STRING = "";
    static final String SINGLE_PROP_STRING = "-Dprop=value";
    static final String MULTI_PROP_STRING = "-Dprop=value -Xmx128M";
    static final Map<String, String> EMPTY_PROP_MAP = Map.of();
    static final Map<String, String> SINGLE_PROP_MAP = Map.of("-Dprop", "value");
    static final Map<String, String> MULTI_PROP_MAP = Map.of("-Dprop", "value", "-Xmx128M", "");

    @Test
    void shouldJoinMapAsJavaOpts() {
        Assertions.assertThat((String)StringUtils.joinAsJavaOpts(EMPTY_PROP_MAP)).isEqualTo(EMPTY_PROP_STRING);
        Assertions.assertThat((String)StringUtils.joinAsJavaOpts(SINGLE_PROP_MAP)).isEqualTo(SINGLE_PROP_STRING);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)StringUtils.joinAsJavaOpts(MULTI_PROP_MAP)).hasSameSizeAs((CharSequence)MULTI_PROP_STRING)).contains(MULTI_PROP_MAP.keySet())).contains(MULTI_PROP_MAP.values());
    }

    @Test
    void shouldSplitPropertiesIntoMap() {
        Assertions.assertThat((Map)StringUtils.splitJavaOpts((String)EMPTY_PROP_STRING)).containsExactlyInAnyOrderEntriesOf(EMPTY_PROP_MAP);
        Assertions.assertThat((Map)StringUtils.splitJavaOpts((String)SINGLE_PROP_STRING)).containsExactlyInAnyOrderEntriesOf(SINGLE_PROP_MAP);
        Assertions.assertThat((Map)StringUtils.splitJavaOpts((String)MULTI_PROP_STRING)).containsExactlyInAnyOrderEntriesOf(MULTI_PROP_MAP);
    }
}

