/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator;

import io.debezium.operator.DebeziumServer;
import io.debezium.operator.model.DebeziumServerSpec;
import jakarta.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class VersionProvider {
    private static final String SNAPSHOT = "SNAPSHOT";
    public static final String LATEST = "latest";
    @ConfigProperty(name="debezium.version", defaultValue="latest")
    String imageVersion;

    public String getImageTag() {
        return this.isSnapshot() ? this.getRollingTag() : this.imageVersion;
    }

    public String getImageTag(DebeziumServer server) {
        String version = ((DebeziumServerSpec)server.getSpec()).getVersion();
        return version != null ? version : this.getImageTag();
    }

    private String getRollingTag() {
        String fullVersion = this.isSnapshot() ? this.imageVersion.substring(0, this.imageVersion.length() - SNAPSHOT.length() - 1) : this.imageVersion;
        String[] parts = fullVersion.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        return "%d.%d".formatted(major, minor);
    }

    public boolean isSnapshot() {
        return this.imageVersion.endsWith(SNAPSHOT);
    }
}

