/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SecretBuildSourceFluentImpl<A extends SecretBuildSourceFluent<A>>
extends BaseFluent<A>
implements SecretBuildSourceFluent<A> {
    private String destinationDir;
    private LocalObjectReferenceBuilder secret;
    private Map<String, Object> additionalProperties;

    public SecretBuildSourceFluentImpl() {
    }

    public SecretBuildSourceFluentImpl(SecretBuildSource instance) {
        this.withDestinationDir(instance.getDestinationDir());
        this.withSecret(instance.getSecret());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getDestinationDir() {
        return this.destinationDir;
    }

    @Override
    public A withDestinationDir(String destinationDir) {
        this.destinationDir = destinationDir;
        return (A)this;
    }

    @Override
    public Boolean hasDestinationDir() {
        return this.destinationDir != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public LocalObjectReference buildSecret() {
        return this.secret != null ? this.secret.build() : null;
    }

    @Override
    public A withSecret(LocalObjectReference secret) {
        this._visitables.get((Object)"secret").remove(this.secret);
        if (secret != null) {
            this.secret = new LocalObjectReferenceBuilder(secret);
            this._visitables.get((Object)"secret").add(this.secret);
        } else {
            this.secret = null;
            this._visitables.get((Object)"secret").remove(this.secret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    public A withNewSecret(String name) {
        return this.withSecret(new LocalObjectReference(name));
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> withNewSecret() {
        return new SecretNestedImpl();
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> withNewSecretLike(LocalObjectReference item) {
        return new SecretNestedImpl(item);
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> editSecret() {
        return this.withNewSecretLike(this.getSecret());
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> editOrNewSecret() {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SecretBuildSourceFluent.SecretNested<A> editOrNewSecretLike(LocalObjectReference item) {
        return this.withNewSecretLike(this.getSecret() != null ? this.getSecret() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretBuildSourceFluentImpl that = (SecretBuildSourceFluentImpl)o;
        if (this.destinationDir != null ? !this.destinationDir.equals(that.destinationDir) : that.destinationDir != null) {
            return false;
        }
        if (this.secret != null ? !this.secret.equals((Object)that.secret) : that.secret != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.destinationDir, this.secret, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.destinationDir != null) {
            sb.append("destinationDir:");
            sb.append(this.destinationDir + ",");
        }
        if (this.secret != null) {
            sb.append("secret:");
            sb.append(this.secret + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretBuildSourceFluent.SecretNested<N>>
    implements SecretBuildSourceFluent.SecretNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        SecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)SecretBuildSourceFluentImpl.this.withSecret(this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

