/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.EgressNetworkPolicyRule;
import io.fabric8.openshift.api.model.EgressNetworkPolicyRuleBuilder;
import io.fabric8.openshift.api.model.EgressNetworkPolicyRuleFluentImpl;
import io.fabric8.openshift.api.model.EgressNetworkPolicySpec;
import io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EgressNetworkPolicySpecFluentImpl<A extends EgressNetworkPolicySpecFluent<A>>
extends BaseFluent<A>
implements EgressNetworkPolicySpecFluent<A> {
    private ArrayList<EgressNetworkPolicyRuleBuilder> egress = new ArrayList();
    private Map<String, Object> additionalProperties;

    public EgressNetworkPolicySpecFluentImpl() {
    }

    public EgressNetworkPolicySpecFluentImpl(EgressNetworkPolicySpec instance) {
        this.withEgress(instance.getEgress());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToEgress(Integer index, EgressNetworkPolicyRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
        this._visitables.get((Object)"egress").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"egress").size(), builder);
        this.egress.add(index >= 0 ? index.intValue() : this.egress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEgress(Integer index, EgressNetworkPolicyRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"egress").size()) {
            this._visitables.get((Object)"egress").add(builder);
        } else {
            this._visitables.get((Object)"egress").set(index, builder);
        }
        if (index < 0 || index >= this.egress.size()) {
            this.egress.add(builder);
        } else {
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEgress(EgressNetworkPolicyRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgress(Collection<EgressNetworkPolicyRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList();
        }
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get((Object)"egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgress(EgressNetworkPolicyRule ... items) {
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get((Object)"egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgress(Collection<EgressNetworkPolicyRule> items) {
        for (EgressNetworkPolicyRule item : items) {
            EgressNetworkPolicyRuleBuilder builder = new EgressNetworkPolicyRuleBuilder(item);
            this._visitables.get((Object)"egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<EgressNetworkPolicyRuleBuilder> each = this.egress.iterator();
        List visitables = this._visitables.get((Object)"egress");
        while (each.hasNext()) {
            EgressNetworkPolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EgressNetworkPolicyRule> getEgress() {
        return this.egress != null ? EgressNetworkPolicySpecFluentImpl.build(this.egress) : null;
    }

    @Override
    public List<EgressNetworkPolicyRule> buildEgress() {
        return this.egress != null ? EgressNetworkPolicySpecFluentImpl.build(this.egress) : null;
    }

    @Override
    public EgressNetworkPolicyRule buildEgress(Integer index) {
        return this.egress.get(index).build();
    }

    @Override
    public EgressNetworkPolicyRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    @Override
    public EgressNetworkPolicyRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    @Override
    public EgressNetworkPolicyRule buildMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        for (EgressNetworkPolicyRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        for (EgressNetworkPolicyRuleBuilder item : this.egress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgress(List<EgressNetworkPolicyRule> egress) {
        if (this.egress != null) {
            this._visitables.get((Object)"egress").removeAll(this.egress);
        }
        if (egress != null) {
            this.egress = new ArrayList();
            for (EgressNetworkPolicyRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    @Override
    public A withEgress(EgressNetworkPolicyRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
        }
        if (egress != null) {
            for (EgressNetworkPolicyRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
        return new EgressNestedImpl();
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(EgressNetworkPolicyRule item) {
        return new EgressNestedImpl(-1, item);
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(Integer index, EgressNetworkPolicyRule item) {
        return new EgressNestedImpl(index, item);
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editEgress(Integer index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public EgressNetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<EgressNetworkPolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.test(this.egress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EgressNetworkPolicySpecFluentImpl that = (EgressNetworkPolicySpecFluentImpl)o;
        if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.egress != null && !this.egress.isEmpty()) {
            sb.append("egress:");
            sb.append(this.egress + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class EgressNestedImpl<N>
    extends EgressNetworkPolicyRuleFluentImpl<EgressNetworkPolicySpecFluent.EgressNested<N>>
    implements EgressNetworkPolicySpecFluent.EgressNested<N>,
    Nested<N> {
        EgressNetworkPolicyRuleBuilder builder;
        Integer index;

        EgressNestedImpl(Integer index, EgressNetworkPolicyRule item) {
            this.index = index;
            this.builder = new EgressNetworkPolicyRuleBuilder(this, item);
        }

        EgressNestedImpl() {
            this.index = -1;
            this.builder = new EgressNetworkPolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)EgressNetworkPolicySpecFluentImpl.this.setToEgress(this.index, this.builder.build());
        }

        @Override
        public N endEgress() {
            return this.and();
        }
    }
}

