/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.polling;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.Cache;
import io.javaoperatorsdk.operator.processing.event.source.CacheKeyMapper;
import io.javaoperatorsdk.operator.processing.event.source.ExternalResourceCachingEventSource;
import io.javaoperatorsdk.operator.processing.event.source.ResourceEventAware;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerResourcePollingEventSource<R, P extends HasMetadata>
extends ExternalResourceCachingEventSource<R, P>
implements ResourceEventAware<P> {
    private static final Logger log = LoggerFactory.getLogger(PerResourcePollingEventSource.class);
    public static final int DEFAULT_EXECUTOR_THREAD_NUMBER = 1;
    private final ScheduledExecutorService executorService;
    private final Map<ResourceID, ScheduledFuture<Void>> scheduledFutures = new ConcurrentHashMap<ResourceID, ScheduledFuture<Void>>();
    private final ResourceFetcher<R, P> resourceFetcher;
    private final Cache<P> resourceCache;
    private final Predicate<P> registerPredicate;
    private final long period;
    private final Set<ResourceID> fetchedForPrimaries = ConcurrentHashMap.newKeySet();

    public PerResourcePollingEventSource(ResourceFetcher<R, P> resourceFetcher, Cache<P> resourceCache, long period, Class<R> resourceClass) {
        this(resourceFetcher, resourceCache, period, null, resourceClass, CacheKeyMapper.singleResourceCacheKeyMapper());
    }

    public PerResourcePollingEventSource(ResourceFetcher<R, P> resourceFetcher, Cache<P> resourceCache, long period, Class<R> resourceClass, CacheKeyMapper<R> cacheKeyMapper) {
        this(resourceFetcher, resourceCache, period, null, resourceClass, cacheKeyMapper);
    }

    public PerResourcePollingEventSource(ResourceFetcher<R, P> resourceFetcher, Cache<P> resourceCache, long period, Predicate<P> registerPredicate, Class<R> resourceClass, CacheKeyMapper<R> cacheKeyMapper) {
        this(resourceFetcher, resourceCache, period, registerPredicate, resourceClass, cacheKeyMapper, new ScheduledThreadPoolExecutor(1));
    }

    public PerResourcePollingEventSource(ResourceFetcher<R, P> resourceFetcher, Cache<P> resourceCache, long period, Predicate<P> registerPredicate, Class<R> resourceClass, CacheKeyMapper<R> cacheKeyMapper, ScheduledExecutorService executorService) {
        super(resourceClass, cacheKeyMapper);
        this.resourceFetcher = resourceFetcher;
        this.resourceCache = resourceCache;
        this.period = period;
        this.registerPredicate = registerPredicate;
        this.executorService = executorService;
    }

    private Set<R> getAndCacheResource(P primary, boolean fromGetter) {
        Set<R> values = this.resourceFetcher.fetchResources(primary);
        this.handleResources(ResourceID.fromResource(primary), values, !fromGetter);
        this.fetchedForPrimaries.add(ResourceID.fromResource(primary));
        return values;
    }

    private void scheduleNextExecution(P primary, Set<R> actualResources) {
        ResourceID primaryID = ResourceID.fromResource(primary);
        Optional<Duration> fetchDelay = this.resourceFetcher.fetchDelay(actualResources, primary);
        Duration fetchDuration = fetchDelay.orElse(Duration.ofMillis(this.period));
        ScheduledFuture<?> scheduledFuture = this.executorService.schedule(new FetchingExecutor(primaryID), fetchDuration.toMillis(), TimeUnit.MILLISECONDS);
        this.scheduledFutures.put(primaryID, scheduledFuture);
    }

    @Override
    public void onResourceCreated(P resource) {
        this.checkAndRegisterTask(resource);
    }

    @Override
    public void onResourceUpdated(P newResource, P oldResource) {
        this.checkAndRegisterTask(newResource);
    }

    @Override
    public void onResourceDeleted(P resource) {
        ResourceID resourceID = ResourceID.fromResource(resource);
        ScheduledFuture<Void> scheduledFuture = this.scheduledFutures.remove(resourceID);
        if (scheduledFuture != null) {
            log.debug("Canceling scheduledFuture for resource: {}", resource);
            scheduledFuture.cancel(true);
        }
        this.handleDelete(resourceID);
        this.fetchedForPrimaries.remove(resourceID);
    }

    private void checkAndRegisterTask(P resource) {
        ResourceID primaryID = ResourceID.fromResource(resource);
        if (this.scheduledFutures.get(primaryID) == null && (this.registerPredicate == null || this.registerPredicate.test(resource))) {
            Map cachedResources = (Map)this.cache.get(primaryID);
            HashSet actualResources = cachedResources == null ? null : new HashSet(cachedResources.values());
            this.scheduleNextExecution(resource, actualResources);
        }
    }

    @Override
    public Set<R> getSecondaryResources(P primary) {
        ResourceID primaryID = ResourceID.fromResource(primary);
        Map cachedValue = (Map)this.cache.get(primaryID);
        if (cachedValue != null && !cachedValue.isEmpty()) {
            return new HashSet(cachedValue.values());
        }
        if (this.fetchedForPrimaries.contains(primaryID)) {
            return Collections.emptySet();
        }
        return this.getAndCacheResource(primary, true);
    }

    @Override
    public void stop() throws OperatorException {
        super.stop();
        this.executorService.shutdownNow();
    }

    public static interface ResourceFetcher<R, P> {
        public Set<R> fetchResources(P var1);

        default public Optional<Duration> fetchDelay(Set<R> lastFetchedResource, P primary) {
            return Optional.empty();
        }
    }

    private class FetchingExecutor
    implements Runnable {
        private final ResourceID primaryID;

        public FetchingExecutor(ResourceID primaryID) {
            this.primaryID = primaryID;
        }

        @Override
        public void run() {
            if (!PerResourcePollingEventSource.this.isRunning()) {
                log.debug("Event source not yet started. Will not run for: {}", (Object)this.primaryID);
                return;
            }
            Optional primary = PerResourcePollingEventSource.this.resourceCache.get(this.primaryID);
            if (primary.isEmpty()) {
                log.warn("No resource in cache for resource ID: {}", (Object)this.primaryID);
            } else {
                Optional<Set> actualResources = primary.map(p -> PerResourcePollingEventSource.this.getAndCacheResource(p, false));
                PerResourcePollingEventSource.this.scheduleNextExecution((HasMetadata)primary.get(), actualResources.orElse(null));
            }
        }
    }
}

