/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.AnyNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.config.ResourceConfiguration;
import io.javaoperatorsdk.operator.health.InformerHealthIndicator;
import io.javaoperatorsdk.operator.processing.LifecycleAware;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.Cache;
import io.javaoperatorsdk.operator.processing.event.source.IndexerResourceCache;
import io.javaoperatorsdk.operator.processing.event.source.informer.InformerWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformerManager<T extends HasMetadata, C extends ResourceConfiguration<T>>
implements LifecycleAware,
IndexerResourceCache<T> {
    private static final Logger log = LoggerFactory.getLogger(InformerManager.class);
    private final Map<String, InformerWrapper<T>> sources = new ConcurrentHashMap<String, InformerWrapper<T>>();
    private Cloner cloner;
    private final C configuration;
    private final MixedOperation<T, KubernetesResourceList<T>, Resource<T>> client;
    private final ResourceEventHandler<T> eventHandler;
    private final Map<String, Function<T, List<String>>> indexers = new HashMap<String, Function<T, List<String>>>();

    public InformerManager(MixedOperation<T, KubernetesResourceList<T>, Resource<T>> client, C configuration, ResourceEventHandler<T> eventHandler) {
        this.client = client;
        this.configuration = configuration;
        this.eventHandler = eventHandler;
    }

    @Override
    public void start() throws OperatorException {
        this.initSources();
        ExecutorServiceManager.boundedExecuteAndWaitForAllToComplete(this.sources.values().stream(), iw -> {
            iw.start();
            return null;
        }, iw -> "InformerStarter-" + iw.getTargetNamespace() + "-" + this.configuration.getResourceClass().getSimpleName());
    }

    private void initSources() {
        if (!this.sources.isEmpty()) {
            throw new IllegalStateException("Some sources already initialized.");
        }
        this.cloner = ConfigurationServiceProvider.instance().getResourceCloner();
        Set<String> targetNamespaces = this.configuration.getEffectiveNamespaces();
        if (ResourceConfiguration.allNamespacesWatched(targetNamespaces)) {
            InformerWrapper<T> source = this.createEventSourceForNamespace("JOSDK_ALL_NAMESPACES");
            log.debug("Registered {} -> {} for any namespace", (Object)this, source);
        } else {
            targetNamespaces.forEach(ns -> {
                InformerWrapper<T> source = this.createEventSourceForNamespace((String)ns);
                log.debug("Registered {} -> {} for namespace: {}", new Object[]{this, source, ns});
            });
        }
    }

    C configuration() {
        return this.configuration;
    }

    public void changeNamespaces(Set<String> namespaces) {
        Set<String> sourcesToRemove = this.sources.keySet().stream().filter(k -> !namespaces.contains(k)).collect(Collectors.toSet());
        log.debug("Stopped informer {} for namespaces: {}", (Object)this, sourcesToRemove);
        sourcesToRemove.forEach(k -> this.sources.remove(k).stop());
        namespaces.forEach(ns -> {
            if (!this.sources.containsKey(ns)) {
                InformerWrapper<T> source = this.createEventSourceForNamespace((String)ns);
                source.start();
                log.debug("Registered new {} -> {} for namespace: {}", new Object[]{this, source, ns});
            }
        });
    }

    private InformerWrapper<T> createEventSourceForNamespace(String namespace) {
        InformerWrapper<T> source;
        if (namespace.equals("JOSDK_ALL_NAMESPACES")) {
            FilterWatchListDeletable filteredBySelectorClient = (FilterWatchListDeletable)((AnyNamespaceOperation)this.client.inAnyNamespace()).withLabelSelector(this.configuration.getLabelSelector());
            source = this.createEventSource(filteredBySelectorClient, this.eventHandler, "JOSDK_ALL_NAMESPACES");
        } else {
            source = this.createEventSource((FilterWatchListDeletable)((NonNamespaceOperation)this.client.inNamespace(namespace)).withLabelSelector(this.configuration.getLabelSelector()), this.eventHandler, namespace);
        }
        source.addIndexers(this.indexers);
        return source;
    }

    private InformerWrapper<T> createEventSource(FilterWatchListDeletable<T, KubernetesResourceList<T>, Resource<T>> filteredBySelectorClient, ResourceEventHandler<T> eventHandler, String namespaceIdentifier) {
        SharedIndexInformer informer = filteredBySelectorClient.runnableInformer(0L);
        this.configuration.getItemStore().ifPresent(arg_0 -> ((SharedIndexInformer)informer).itemStore(arg_0));
        InformerWrapper<T> source = new InformerWrapper<T>(informer, namespaceIdentifier);
        source.addEventHandler(eventHandler);
        this.sources.put(namespaceIdentifier, source);
        return source;
    }

    @Override
    public void stop() {
        this.sources.forEach((ns, source) -> {
            try {
                log.debug("Stopping informer for namespace: {} -> {}", ns, source);
                source.stop();
            }
            catch (Exception e) {
                log.warn("Error stopping informer for namespace: {} -> {}", new Object[]{ns, source, e});
            }
        });
        this.sources.clear();
    }

    @Override
    public Stream<T> list(Predicate<T> predicate) {
        if (predicate == null) {
            return this.sources.values().stream().flatMap(Cache::list);
        }
        return this.sources.values().stream().flatMap(i -> i.list(predicate));
    }

    @Override
    public Stream<T> list(String namespace, Predicate<T> predicate) {
        if (this.isWatchingAllNamespaces()) {
            return this.getSource("JOSDK_ALL_NAMESPACES").map(source -> source.list(namespace, predicate)).orElseGet(Stream::empty);
        }
        return this.getSource(namespace).map(source -> source.list(predicate)).orElseGet(Stream::empty);
    }

    @Override
    public Optional<T> get(ResourceID resourceID) {
        return this.getSource(resourceID.getNamespace().orElse("JOSDK_ALL_NAMESPACES")).flatMap(source -> source.get(resourceID)).map(this.cloner::clone);
    }

    @Override
    public Stream<ResourceID> keys() {
        return this.sources.values().stream().flatMap(Cache::keys);
    }

    private boolean isWatchingAllNamespaces() {
        return this.sources.containsKey("JOSDK_ALL_NAMESPACES");
    }

    private Optional<InformerWrapper<T>> getSource(String namespace) {
        namespace = this.isWatchingAllNamespaces() || namespace == null ? "JOSDK_ALL_NAMESPACES" : namespace;
        return Optional.ofNullable(this.sources.get(namespace));
    }

    @Override
    public void addIndexers(Map<String, Function<T, List<String>>> indexers) {
        this.indexers.putAll(indexers);
    }

    @Override
    public List<T> byIndex(String indexName, String indexKey) {
        return this.sources.values().stream().map(s -> s.byIndex(indexName, indexKey)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String toString() {
        String selector = this.configuration.getLabelSelector();
        return "InformerManager [" + ReconcilerUtils.getResourceTypeNameWithVersion(this.configuration.getResourceClass()) + "] watching: " + this.configuration.getEffectiveNamespaces() + (String)(selector != null ? " selector: " + selector : "");
    }

    public Map<String, InformerHealthIndicator> informerHealthIndicators() {
        return Collections.unmodifiableMap(this.sources);
    }
}

