/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.RetryInfo;
import io.javaoperatorsdk.operator.processing.KubernetesResourceUtils;
import io.javaoperatorsdk.operator.processing.LifecycleAware;
import io.javaoperatorsdk.operator.processing.MDCUtils;
import io.javaoperatorsdk.operator.processing.event.Event;
import io.javaoperatorsdk.operator.processing.event.EventHandler;
import io.javaoperatorsdk.operator.processing.event.EventSourceManager;
import io.javaoperatorsdk.operator.processing.event.ExecutionScope;
import io.javaoperatorsdk.operator.processing.event.PostExecutionControl;
import io.javaoperatorsdk.operator.processing.event.ReconciliationDispatcher;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.ResourceState;
import io.javaoperatorsdk.operator.processing.event.ResourceStateManager;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.Cache;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceAction;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEvent;
import io.javaoperatorsdk.operator.processing.event.source.timer.TimerEventSource;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import io.javaoperatorsdk.operator.processing.retry.RetryExecution;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessor<P extends HasMetadata>
implements EventHandler,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(EventProcessor.class);
    private static final long MINIMAL_RATE_LIMIT_RESCHEDULE_DURATION = 50L;
    private volatile boolean running;
    private final ControllerConfiguration<?> controllerConfiguration;
    private final ReconciliationDispatcher<P> reconciliationDispatcher;
    private final Retry retry;
    private final Metrics metrics;
    private final Cache<P> cache;
    private final EventSourceManager<P> eventSourceManager;
    private final RateLimiter<? extends RateLimiter.RateLimitState> rateLimiter;
    private final ResourceStateManager resourceStateManager = new ResourceStateManager();
    private final Map<String, Object> metricsMetadata;
    private ExecutorService executor;

    public EventProcessor(EventSourceManager<P> eventSourceManager) {
        this(eventSourceManager.getController().getConfiguration(), eventSourceManager.getControllerResourceEventSource(), new ReconciliationDispatcher<P>(eventSourceManager.getController()), ConfigurationServiceProvider.instance().getMetrics(), eventSourceManager);
    }

    EventProcessor(ControllerConfiguration controllerConfiguration, ReconciliationDispatcher<P> reconciliationDispatcher, EventSourceManager<P> eventSourceManager, Metrics metrics) {
        this(controllerConfiguration, eventSourceManager.getControllerResourceEventSource(), reconciliationDispatcher, metrics, eventSourceManager);
    }

    private EventProcessor(ControllerConfiguration controllerConfiguration, Cache<P> cache, ReconciliationDispatcher<P> reconciliationDispatcher, Metrics metrics, EventSourceManager<P> eventSourceManager) {
        this.controllerConfiguration = controllerConfiguration;
        this.running = false;
        this.reconciliationDispatcher = reconciliationDispatcher;
        this.retry = controllerConfiguration.getRetry();
        this.cache = cache;
        this.metrics = metrics != null ? metrics : Metrics.NOOP;
        this.eventSourceManager = eventSourceManager;
        this.rateLimiter = controllerConfiguration.getRateLimiter();
        this.metricsMetadata = Optional.ofNullable(eventSourceManager.getController()).map(c -> Map.of("josdk.resource.gvk", c.getAssociatedGroupVersionKind(), "controller.name", controllerConfiguration.getName())).orElseGet(HashMap::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void handleEvent(Event event) {
        try {
            log.debug("Received event: {}", (Object)event);
            ResourceID resourceID = event.getRelatedCustomResourceID();
            ResourceState state = this.resourceStateManager.getOrCreate(event.getRelatedCustomResourceID());
            MDCUtils.addResourceIDInfo(resourceID);
            this.metrics.receivedEvent(event, this.metricsMetadata);
            this.handleEventMarking(event, state);
            if (!this.running) {
                log.debug("Skipping event: {} because the event processor is not started", (Object)event);
                return;
            }
            this.handleMarkedEventForResource(state);
        }
        finally {
            MDCUtils.removeResourceIDInfo();
        }
    }

    private void handleMarkedEventForResource(ResourceState state) {
        if (state.deleteEventPresent()) {
            this.cleanupForDeletedEvent(state.getId());
        } else if (!state.processedMarkForDeletionPresent()) {
            this.submitReconciliationExecution(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitReconciliationExecution(ResourceState state) {
        try {
            boolean controllerUnderExecution = this.isControllerUnderExecution(state);
            ResourceID resourceID = state.getId();
            Optional<P> maybeLatest = this.cache.get(resourceID);
            maybeLatest.ifPresent(MDCUtils::addResourceInfo);
            if (!controllerUnderExecution && maybeLatest.isPresent()) {
                Optional<Duration> rateLimiterPermission;
                RateLimiter.RateLimitState rateLimit = state.getRateLimit();
                if (rateLimit == null) {
                    rateLimit = this.rateLimiter.initState();
                    state.setRateLimit(rateLimit);
                }
                if ((rateLimiterPermission = this.rateLimiter.isLimited(rateLimit)).isPresent()) {
                    this.handleRateLimitedSubmission(resourceID, rateLimiterPermission.get());
                    return;
                }
                state.setUnderProcessing(true);
                HasMetadata latest = (HasMetadata)maybeLatest.get();
                ExecutionScope executionScope = new ExecutionScope(state.getRetry());
                state.unMarkEventReceived();
                this.metrics.reconcileCustomResource(latest, (RetryInfo)state.getRetry(), this.metricsMetadata);
                log.debug("Executing events for custom resource. Scope: {}", executionScope);
                this.executor.execute(new ReconcilerExecutor(resourceID, executionScope));
            } else {
                log.debug("Skipping executing controller for resource id: {}. Controller in execution: {}. Latest Resource present: {}", new Object[]{resourceID, controllerUnderExecution, maybeLatest.isPresent()});
                if (maybeLatest.isEmpty()) {
                    log.debug("no custom resource found in cache for resource id: {}", (Object)resourceID);
                }
            }
        }
        finally {
            MDCUtils.removeResourceInfo();
        }
    }

    private void handleEventMarking(Event event, ResourceState state) {
        ResourceID relatedCustomResourceID = event.getRelatedCustomResourceID();
        if (event instanceof ResourceEvent) {
            ResourceEvent resourceEvent = (ResourceEvent)event;
            if (resourceEvent.getAction() == ResourceAction.DELETED) {
                log.debug("Marking delete event received for: {}", (Object)relatedCustomResourceID);
                state.markDeleteEventReceived();
            } else {
                if (state.processedMarkForDeletionPresent() && this.isResourceMarkedForDeletion(resourceEvent)) {
                    log.debug("Skipping mark of event received, since already processed mark for deletion and resource marked for deletion: {}", (Object)relatedCustomResourceID);
                    return;
                }
                this.markEventReceived(state);
            }
        } else if (!state.deleteEventPresent() || !state.processedMarkForDeletionPresent()) {
            this.markEventReceived(state);
        } else if (log.isDebugEnabled()) {
            log.debug("Skipped marking event as received. Delete event present: {}, processed mark for deletion: {}", (Object)state.deleteEventPresent(), (Object)state.processedMarkForDeletionPresent());
        }
    }

    private void markEventReceived(ResourceState state) {
        log.debug("Marking event received for: {}", (Object)state.getId());
        state.markEventReceived();
    }

    private boolean isResourceMarkedForDeletion(ResourceEvent resourceEvent) {
        return resourceEvent.getResource().map(HasMetadata::isMarkedForDeletion).orElse(false);
    }

    private void handleRateLimitedSubmission(ResourceID resourceID, Duration minimalDuration) {
        long minimalDurationMillis = minimalDuration.toMillis();
        log.debug("Rate limited resource: {}, rescheduled in {} millis", (Object)resourceID, (Object)minimalDurationMillis);
        this.retryEventSource().scheduleOnce(resourceID, Math.max(minimalDurationMillis, 50L));
    }

    synchronized void eventProcessingFinished(ExecutionScope<P> executionScope, PostExecutionControl<P> postExecutionControl) {
        if (!this.running) {
            return;
        }
        ResourceID resourceID = executionScope.getResourceID();
        ResourceState state = this.resourceStateManager.getOrCreate(resourceID);
        log.debug("Event processing finished. Scope: {}, PostExecutionControl: {}", executionScope, postExecutionControl);
        this.unsetUnderExecution(resourceID);
        if (this.isRetryConfigured() && postExecutionControl.exceptionDuringExecution() && !state.deleteEventPresent()) {
            this.handleRetryOnException(executionScope, postExecutionControl.getRuntimeException().orElseThrow());
            return;
        }
        this.cleanupOnSuccessfulExecution(executionScope);
        this.metrics.finishedReconciliation((HasMetadata)executionScope.getResource(), this.metricsMetadata);
        if (state.deleteEventPresent()) {
            this.cleanupForDeletedEvent(executionScope.getResourceID());
        } else if (postExecutionControl.isFinalizerRemoved()) {
            state.markProcessedMarkForDeletion();
            this.metrics.cleanupDoneFor(resourceID, this.metricsMetadata);
        } else {
            postExecutionControl.getUpdatedCustomResource().ifPresent(p -> {
                if (!postExecutionControl.updateIsStatusPatch()) {
                    this.eventSourceManager.getControllerResourceEventSource().handleRecentResourceUpdate(ResourceID.fromResource(p), p, executionScope.getResource());
                }
            });
            if (state.eventPresent()) {
                this.submitReconciliationExecution(state);
            } else {
                this.reScheduleExecutionIfInstructed(postExecutionControl, executionScope.getResource());
            }
        }
    }

    private void reScheduleExecutionIfInstructed(PostExecutionControl<P> postExecutionControl, P customResource) {
        postExecutionControl.getReScheduleDelay().ifPresentOrElse(delay -> {
            ResourceID resourceID = ResourceID.fromResource(customResource);
            log.debug("Rescheduling event for resource: {} with delay: {}", (Object)resourceID, delay);
            this.retryEventSource().scheduleOnce(resourceID, (long)delay);
        }, () -> this.scheduleExecutionForMaxReconciliationInterval(customResource));
    }

    private void scheduleExecutionForMaxReconciliationInterval(P customResource) {
        this.controllerConfiguration.maxReconciliationInterval().ifPresent(m -> {
            ResourceID resourceID = ResourceID.fromResource(customResource);
            long delay = m.toMillis();
            log.debug("Rescheduling event for max reconciliation interval for resource: {} : with delay: {}", (Object)resourceID, (Object)delay);
            this.retryEventSource().scheduleOnce(resourceID, delay);
        });
    }

    TimerEventSource<P> retryEventSource() {
        return this.eventSourceManager.retryEventSource();
    }

    private void handleRetryOnException(ExecutionScope<P> executionScope, Exception exception) {
        ResourceState state = this.getOrInitRetryExecution(executionScope);
        ResourceID resourceID = state.getId();
        boolean eventPresent = state.eventPresent();
        state.markEventReceived();
        if (eventPresent) {
            log.debug("New events exists for for resource id: {}", (Object)resourceID);
            this.submitReconciliationExecution(state);
            return;
        }
        Optional<Long> nextDelay = state.getRetry().nextDelay();
        nextDelay.ifPresentOrElse(delay -> {
            log.debug("Scheduling timer event for retry with delay:{} for resource: {}", delay, (Object)resourceID);
            this.metrics.failedReconciliation((HasMetadata)executionScope.getResource(), exception, this.metricsMetadata);
            this.retryEventSource().scheduleOnce(resourceID, (long)delay);
        }, () -> {
            log.error("Exhausted retries for {}", (Object)executionScope);
            this.scheduleExecutionForMaxReconciliationInterval(executionScope.getResource());
        });
    }

    private void cleanupOnSuccessfulExecution(ExecutionScope<P> executionScope) {
        log.debug("Cleanup for successful execution for resource: {}", (Object)KubernetesResourceUtils.getName(executionScope.getResource()));
        if (this.isRetryConfigured()) {
            this.resourceStateManager.getOrCreate(executionScope.getResourceID()).setRetry(null);
        }
        this.retryEventSource().cancelOnceSchedule(executionScope.getResourceID());
    }

    private ResourceState getOrInitRetryExecution(ExecutionScope<P> executionScope) {
        ResourceState state = this.resourceStateManager.getOrCreate(executionScope.getResourceID());
        RetryExecution retryExecution = state.getRetry();
        if (retryExecution == null) {
            retryExecution = this.retry.initExecution();
            state.setRetry(retryExecution);
        }
        return state;
    }

    private void cleanupForDeletedEvent(ResourceID resourceID) {
        log.debug("Cleaning up for delete event for: {}", (Object)resourceID);
        this.resourceStateManager.remove(resourceID);
        this.metrics.cleanupDoneFor(resourceID, this.metricsMetadata);
    }

    private boolean isControllerUnderExecution(ResourceState state) {
        return state.isUnderProcessing();
    }

    private void unsetUnderExecution(ResourceID resourceID) {
        this.resourceStateManager.getOrCreate(resourceID).setUnderProcessing(false);
    }

    private boolean isRetryConfigured() {
        return this.retry != null;
    }

    @Override
    public synchronized void stop() {
        this.running = false;
    }

    @Override
    public void start() throws OperatorException {
        this.executor = ExecutorServiceManager.instance().executorService();
        this.running = true;
        this.handleAlreadyMarkedEvents();
    }

    private void handleAlreadyMarkedEvents() {
        for (ResourceState state : this.resourceStateManager.resourcesWithEventPresent()) {
            this.handleMarkedEventForResource(state);
        }
    }

    private String controllerName() {
        return this.controllerConfiguration.getName();
    }

    public synchronized boolean isUnderProcessing(ResourceID resourceID) {
        return this.isControllerUnderExecution(this.resourceStateManager.getOrCreate(resourceID));
    }

    private class ReconcilerExecutor
    implements Runnable {
        private final ExecutionScope<P> executionScope;
        private final ResourceID resourceID;

        private ReconcilerExecutor(ResourceID resourceID, ExecutionScope<P> executionScope) {
            this.executionScope = executionScope;
            this.resourceID = resourceID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!EventProcessor.this.running) {
                log.debug("Event processor not running skipping resource processing: {}", (Object)this.resourceID);
                return;
            }
            Thread thread = Thread.currentThread();
            String name = thread.getName();
            try {
                Optional actualResource = EventProcessor.this.cache.get(this.resourceID);
                if (actualResource.isEmpty()) {
                    log.debug("Skipping execution; primary resource missing from cache: {}", (Object)this.resourceID);
                    return;
                }
                actualResource.ifPresent(this.executionScope::setResource);
                MDCUtils.addResourceInfo(this.executionScope.getResource());
                EventProcessor.this.metrics.reconciliationExecutionStarted((HasMetadata)this.executionScope.getResource(), EventProcessor.this.metricsMetadata);
                thread.setName("ReconcilerExecutor-" + EventProcessor.this.controllerName() + "-" + thread.getId());
                PostExecutionControl postExecutionControl = EventProcessor.this.reconciliationDispatcher.handleExecution(this.executionScope);
                EventProcessor.this.eventProcessingFinished(this.executionScope, postExecutionControl);
            }
            finally {
                EventProcessor.this.metrics.reconciliationExecutionFinished((HasMetadata)this.executionScope.getResource(), EventProcessor.this.metricsMetadata);
                thread.setName(name);
                MDCUtils.removeResourceInfo();
            }
        }

        public String toString() {
            return EventProcessor.this.controllerName() + " -> " + (this.executionScope.getResource() != null ? this.executionScope : this.resourceID);
        }
    }
}

