/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DefaultManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DefaultWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class ManagedWorkflowSupport {
    private static final ManagedWorkflowSupport instance = new ManagedWorkflowSupport();

    static ManagedWorkflowSupport instance() {
        return instance;
    }

    private ManagedWorkflowSupport() {
    }

    public void checkForNameDuplication(List<DependentResourceSpec> dependentResourceSpecs) {
        if (dependentResourceSpecs == null) {
            return;
        }
        int size = dependentResourceSpecs.size();
        if (size == 0) {
            return;
        }
        HashSet uniqueNames = new HashSet(size);
        HashSet duplicatedNames = new HashSet(size);
        dependentResourceSpecs.forEach(spec -> {
            String name = spec.getName();
            if (!uniqueNames.add(name)) {
                duplicatedNames.add(name);
            }
        });
        if (!duplicatedNames.isEmpty()) {
            throw new OperatorException("Duplicated dependent resource name(s): " + duplicatedNames);
        }
    }

    public <P extends HasMetadata> ManagedWorkflow<P> createWorkflow(List<DependentResourceSpec> dependentResourceSpecs) {
        return this.createAsDefault(dependentResourceSpecs);
    }

    <P extends HasMetadata> DefaultManagedWorkflow<P> createAsDefault(List<DependentResourceSpec> dependentResourceSpecs) {
        boolean[] cleanerHolder = new boolean[]{false};
        List<DependentResourceSpec> orderedResourceSpecs = this.orderAndDetectCycles(dependentResourceSpecs, cleanerHolder);
        return new DefaultManagedWorkflow(orderedResourceSpecs, cleanerHolder[0]);
    }

    private List<DependentResourceSpec> orderAndDetectCycles(List<DependentResourceSpec> dependentResourceSpecs, boolean[] cleanerHolder) {
        Map<String, DRInfo> drInfosByName = this.createDRInfos(dependentResourceSpecs);
        ArrayList<DependentResourceSpec> orderedSpecs = new ArrayList<DependentResourceSpec>(dependentResourceSpecs.size());
        HashSet alreadyVisited = new HashSet();
        Set<DependentResourceSpec> toVisit = this.getTopDependentResources(dependentResourceSpecs);
        while (!toVisit.isEmpty()) {
            HashSet<DependentResourceSpec> toVisitNext = new HashSet<DependentResourceSpec>();
            toVisit.forEach(dr -> {
                String name;
                DRInfo drInfo;
                if (cleanerHolder != null) {
                    boolean bl = cleanerHolder[0] = cleanerHolder[0] || DefaultWorkflow.isDeletable(dr.getDependentResourceClass());
                }
                if ((drInfo = (DRInfo)drInfosByName.get(name = dr.getName())) != null) {
                    drInfo.waitingForCompletion.forEach(spec -> {
                        if (this.isReadyForVisit((DependentResourceSpec)spec, alreadyVisited, name)) {
                            toVisitNext.add((DependentResourceSpec)spec);
                        }
                    });
                    orderedSpecs.add((DependentResourceSpec)dr);
                }
                alreadyVisited.add(name);
            });
            toVisit = toVisitNext;
        }
        if (orderedSpecs.size() != dependentResourceSpecs.size()) {
            throw new OperatorException("Cycle(s) between dependent resources.");
        }
        return orderedSpecs;
    }

    public List<DependentResourceSpec> orderAndDetectCycles(List<DependentResourceSpec> dependentResourceSpecs) {
        return this.orderAndDetectCycles(dependentResourceSpecs, null);
    }

    private boolean isReadyForVisit(DependentResourceSpec dr, Set<String> alreadyVisited, String alreadyPresentName) {
        for (String name : dr.getDependsOn()) {
            if (name.equals(alreadyPresentName) || alreadyVisited.contains(name)) continue;
            return false;
        }
        return true;
    }

    private Set<DependentResourceSpec> getTopDependentResources(List<DependentResourceSpec> dependentResourceSpecs) {
        return dependentResourceSpecs.stream().filter(r -> r.getDependsOn().isEmpty()).collect(Collectors.toSet());
    }

    private Map<String, DRInfo> createDRInfos(List<DependentResourceSpec> dependentResourceSpecs) {
        Map<String, DRInfo> infos = dependentResourceSpecs.stream().map(x$0 -> new DRInfo((DependentResourceSpec)x$0)).collect(Collectors.toMap(DRInfo::name, Function.identity()));
        dependentResourceSpecs.forEach(spec -> spec.getDependsOn().forEach(name -> {
            DRInfo drInfo = (DRInfo)infos.get(name);
            drInfo.add((DependentResourceSpec)spec);
        }));
        return infos;
    }

    private static class DRInfo {
        private final DependentResourceSpec spec;
        private final List<DependentResourceSpec> waitingForCompletion;

        private DRInfo(DependentResourceSpec spec) {
            this.spec = spec;
            this.waitingForCompletion = new LinkedList<DependentResourceSpec>();
        }

        void add(DependentResourceSpec spec) {
            this.waitingForCompletion.add(spec);
        }

        String name() {
            return this.spec.getName();
        }
    }
}

