/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.workflow;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.dependent.workflow.DependentResourceNode;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public abstract class AbstractWorkflowExecutor<P extends HasMetadata> {
    protected final Workflow<P> workflow;
    protected final P primary;
    protected final Context<P> context;
    private final Set<DependentResourceNode> alreadyVisited = ConcurrentHashMap.newKeySet();
    private final Map<DependentResourceNode, Future<?>> actualExecutions = new ConcurrentHashMap();
    private final Map<DependentResourceNode, Exception> exceptionsDuringExecution = new ConcurrentHashMap<DependentResourceNode, Exception>();

    public AbstractWorkflowExecutor(Workflow<P> workflow, P primary, Context<P> context) {
        this.workflow = workflow;
        this.primary = primary;
        this.context = context;
    }

    protected abstract Logger logger();

    protected synchronized void waitForScheduledExecutionsToRun() {
        try {
            while (true) {
                this.wait();
                if (!this.noMoreExecutionsScheduled()) {
                    this.logger().warn("Notified but still resources under execution. This should not happen.");
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException e) {
            if (this.noMoreExecutionsScheduled()) {
                this.logger().debug("interrupted, no more executions for: {}", (Object)ResourceID.fromResource(this.primary));
                return;
            }
            this.logger().error("Thread interrupted for primary: {}", (Object)ResourceID.fromResource(this.primary), (Object)e);
            throw new OperatorException(e);
        }
    }

    protected boolean noMoreExecutionsScheduled() {
        return this.actualExecutions.isEmpty();
    }

    protected boolean alreadyVisited(DependentResourceNode<?, P> dependentResourceNode) {
        return this.alreadyVisited.contains(dependentResourceNode);
    }

    protected void markAsVisited(DependentResourceNode<?, P> dependentResourceNode) {
        this.alreadyVisited.add(dependentResourceNode);
    }

    protected boolean isExecutingNow(DependentResourceNode<?, P> dependentResourceNode) {
        return this.actualExecutions.containsKey(dependentResourceNode);
    }

    protected void markAsExecuting(DependentResourceNode<?, P> dependentResourceNode, Future<?> future) {
        this.actualExecutions.put(dependentResourceNode, future);
    }

    protected synchronized void handleExceptionInExecutor(DependentResourceNode<?, P> dependentResourceNode, RuntimeException e) {
        this.exceptionsDuringExecution.put(dependentResourceNode, e);
    }

    protected boolean isInError(DependentResourceNode<?, P> dependentResourceNode) {
        return this.exceptionsDuringExecution.containsKey(dependentResourceNode);
    }

    protected Map<DependentResource, Exception> getErroredDependents() {
        return this.exceptionsDuringExecution.entrySet().stream().collect(Collectors.toMap(e -> ((DependentResourceNode)e.getKey()).getDependentResource(), Map.Entry::getValue));
    }

    protected synchronized void handleNodeExecutionFinish(DependentResourceNode<?, P> dependentResourceNode) {
        this.logger().debug("Finished execution for: {}", dependentResourceNode);
        this.actualExecutions.remove(dependentResourceNode);
        if (this.noMoreExecutionsScheduled()) {
            this.notifyAll();
        }
    }

    protected <R> boolean isConditionMet(Optional<Condition<R, P>> condition, DependentResource<R, P> dependentResource) {
        return condition.map(c -> c.isMet(dependentResource, this.primary, this.context)).orElse(true);
    }
}

