/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.zjsonpatch.JsonDiff;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.reconciler.Context;

public interface ResourceUpdatePreProcessor<R extends HasMetadata> {
    public R replaceSpecOnActual(R var1, R var2, Context<?> var3);

    default public boolean matches(R actual, R desired, boolean equality) {
        ObjectMapper objectMapper = ConfigurationServiceProvider.instance().getObjectMapper();
        JsonNode desiredSpecNode = objectMapper.valueToTree(ReconcilerUtils.getSpec(desired));
        JsonNode actualSpecNode = objectMapper.valueToTree(ReconcilerUtils.getSpec(actual));
        JsonNode diffJsonPatch = JsonDiff.asJson((JsonNode)desiredSpecNode, (JsonNode)actualSpecNode);
        int diffNumber = diffJsonPatch.size();
        if (equality && diffNumber > 0) {
            return false;
        }
        for (int i = 0; i < diffNumber; ++i) {
            String operation = diffJsonPatch.get(i).get("op").asText();
            if (operation.equals("add")) continue;
            return false;
        }
        return true;
    }
}

