/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.reconciler;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import java.util.Optional;
import java.util.function.Function;

public class ResourceIDMatcherDiscriminator<R extends HasMetadata, P extends HasMetadata>
implements ResourceDiscriminator<R, P> {
    private final Function<P, ResourceID> mapper;

    public ResourceIDMatcherDiscriminator(Function<P, ResourceID> mapper) {
        this.mapper = mapper;
    }

    @Override
    public Optional<R> distinguish(Class<R> resource, P primary, Context<P> context) {
        ResourceID resourceID = this.mapper.apply(primary);
        return context.getSecondaryResources(resource).stream().filter(resourceID::isSameResource).findFirst();
    }
}

