/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.Utils;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceManager {
    private static final Logger log = LoggerFactory.getLogger(ExecutorServiceManager.class);
    private static ExecutorServiceManager instance;
    private final ExecutorService executor;
    private final ExecutorService workflowExecutor;
    private final ExecutorService cachingExecutorService = Executors.newCachedThreadPool();

    private ExecutorServiceManager(ExecutorService executor, ExecutorService workflowExecutor) {
        this.executor = new InstrumentedExecutorService(executor);
        this.workflowExecutor = new InstrumentedExecutorService(workflowExecutor);
    }

    public static synchronized void init() {
        if (instance == null) {
            ConfigurationService configuration = ConfigurationServiceProvider.instance();
            ExecutorService executorService = configuration.getExecutorService();
            ExecutorService workflowExecutorService = configuration.getWorkflowExecutorService();
            instance = new ExecutorServiceManager(executorService, workflowExecutorService);
            log.debug("Initialized ExecutorServiceManager executor: {}, workflow executor: {}, timeout: {}", new Object[]{executorService.getClass(), workflowExecutorService.getClass(), configuration.getTerminationTimeoutSeconds()});
        } else {
            log.debug("Already started, reusing already setup instance!");
        }
    }

    public static synchronized void reset() {
        ExecutorServiceManager.instance().doStop(Duration.ZERO);
        instance = null;
        ExecutorServiceManager.init();
    }

    public static synchronized void stop(Duration gracefulShutdownTimeout) {
        if (instance != null) {
            instance.doStop(gracefulShutdownTimeout);
        }
        instance = null;
    }

    public static synchronized ExecutorServiceManager instance() {
        if (instance == null) {
            ExecutorServiceManager.init();
        }
        return instance;
    }

    public static <T> void boundedExecuteAndWaitForAllToComplete(Stream<T> stream, Function<T, Void> task, Function<T, String> threadNamer) {
        ExecutorServiceManager.executeAndWaitForAllToComplete(stream, task, threadNamer, ExecutorServiceManager.instance().cachingExecutorService());
    }

    public static <T> void executeAndWaitForAllToComplete(Stream<T> stream, Function<T, Void> task, Function<T, String> threadNamer, ExecutorService executorService) {
        InstrumentedExecutorService instrumented = new InstrumentedExecutorService(executorService);
        try {
            instrumented.invokeAll(stream.map(item -> () -> {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                thread.setName((String)threadNamer.apply(item));
                try {
                    task.apply(item);
                    Void void_ = null;
                    return void_;
                }
                finally {
                    thread.setName(name);
                }
            }).collect(Collectors.toList())).forEach(f -> {
                try {
                    f.get();
                }
                catch (ExecutionException e) {
                    throw new OperatorException(e.getCause());
                }
                catch (InterruptedException e) {
                    log.warn("Interrupted.", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            });
        }
        catch (InterruptedException e) {
            log.warn("Interrupted.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public ExecutorService executorService() {
        return this.executor;
    }

    public ExecutorService workflowExecutorService() {
        return this.workflowExecutor;
    }

    public ExecutorService cachingExecutorService() {
        return this.cachingExecutorService;
    }

    private void doStop(Duration gracefulShutdownTimeout) {
        try {
            ExecutorService parallelExec = Executors.newFixedThreadPool(3);
            log.debug("Closing executor");
            parallelExec.invokeAll(List.of(ExecutorServiceManager.shutdown(this.executor, gracefulShutdownTimeout), ExecutorServiceManager.shutdown(this.workflowExecutor, gracefulShutdownTimeout), ExecutorServiceManager.shutdown(this.cachingExecutorService, gracefulShutdownTimeout)));
            parallelExec.shutdownNow();
        }
        catch (InterruptedException e) {
            log.debug("Exception closing executor: {}", (Object)e.getLocalizedMessage());
            Thread.currentThread().interrupt();
        }
    }

    private static Callable<Void> shutdown(ExecutorService executorService, Duration gracefulShutdownTimeout) {
        return () -> {
            executorService.shutdown();
            if (!executorService.awaitTermination(gracefulShutdownTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
                executorService.shutdownNow();
            }
            return null;
        };
    }

    private static class InstrumentedExecutorService
    implements ExecutorService {
        private final boolean debug;
        private final ExecutorService executor;

        private InstrumentedExecutorService(ExecutorService executor) {
            if (executor == null) {
                throw new NullPointerException();
            }
            this.executor = executor;
            this.debug = Utils.debugThreadPool();
        }

        @Override
        public void shutdown() {
            if (this.debug) {
                Thread.dumpStack();
            }
            this.executor.shutdown();
        }

        @Override
        public List<Runnable> shutdownNow() {
            return this.executor.shutdownNow();
        }

        @Override
        public boolean isShutdown() {
            return this.executor.isShutdown();
        }

        @Override
        public boolean isTerminated() {
            return this.executor.isTerminated();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.awaitTermination(timeout, unit);
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            return this.executor.submit(task, result);
        }

        @Override
        public Future<?> submit(Runnable task) {
            return this.executor.submit(task);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return this.executor.invokeAll(tasks);
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            return this.executor.invokeAll(tasks, timeout, unit);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            return this.executor.invokeAny(tasks);
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.executor.invokeAny(tasks, timeout, unit);
        }

        @Override
        public void execute(Runnable command) {
            this.executor.execute(command);
        }
    }
}

