/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.ResourceConfiguration;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Optional;
import java.util.Set;

public class DefaultResourceConfiguration<R extends HasMetadata>
implements ResourceConfiguration<R> {
    private final Class<R> resourceClass;
    private final String resourceTypeName;
    private final OnAddFilter<R> onAddFilter;
    private final OnUpdateFilter<R> onUpdateFilter;
    private final GenericFilter<R> genericFilter;
    private final String labelSelector;
    private final Set<String> namespaces;
    private final ItemStore<R> itemStore;

    protected DefaultResourceConfiguration(Class<R> resourceClass, Set<String> namespaces, String labelSelector, OnAddFilter<R> onAddFilter, OnUpdateFilter<R> onUpdateFilter, GenericFilter<R> genericFilter, ItemStore<R> itemStore) {
        this.resourceClass = resourceClass;
        this.resourceTypeName = ReconcilerUtils.getResourceTypeName(resourceClass);
        this.onAddFilter = onAddFilter;
        this.onUpdateFilter = onUpdateFilter;
        this.genericFilter = genericFilter;
        this.namespaces = ResourceConfiguration.ensureValidNamespaces(namespaces);
        this.labelSelector = ResourceConfiguration.ensureValidLabelSelector(labelSelector);
        this.itemStore = itemStore;
    }

    @Override
    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    @Override
    public String getLabelSelector() {
        return this.labelSelector;
    }

    @Override
    public Set<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public Class<R> getResourceClass() {
        return this.resourceClass;
    }

    @Override
    public Optional<OnAddFilter<R>> onAddFilter() {
        return Optional.ofNullable(this.onAddFilter);
    }

    @Override
    public Optional<OnUpdateFilter<R>> onUpdateFilter() {
        return Optional.ofNullable(this.onUpdateFilter);
    }

    @Override
    public Optional<GenericFilter<R>> genericFilter() {
        return Optional.ofNullable(this.genericFilter);
    }

    @Override
    public Optional<ItemStore<R>> getItemStore() {
        return Optional.ofNullable(this.itemStore);
    }
}

