/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.javaoperatorsdk.operator.api.config.BaseConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceOverrider;
import io.javaoperatorsdk.operator.api.config.Utils;
import java.util.function.Consumer;

public class ConfigurationServiceProvider {
    private static ConfigurationService instance;
    private static ConfigurationService defaultConfigurationService;
    private static boolean alreadyConfigured;

    private ConfigurationServiceProvider() {
    }

    public static synchronized ConfigurationService instance() {
        if (instance == null) {
            ConfigurationServiceProvider.set(defaultConfigurationService);
        }
        return instance;
    }

    public static synchronized void set(ConfigurationService instance) {
        ConfigurationServiceProvider.set(instance, false);
    }

    private static void set(ConfigurationService instance, boolean overriding) {
        ConfigurationService current = ConfigurationServiceProvider.instance;
        if (!overriding) {
            if (current != null && !current.equals(instance)) {
                throw new IllegalStateException("A ConfigurationService has already been set and cannot be set again. Current: " + current.getClass().getCanonicalName());
            }
        } else {
            if (alreadyConfigured) {
                throw new IllegalStateException("The ConfigurationService has already been overridden once and cannot be changed again. Current: " + current.getClass().getCanonicalName());
            }
            alreadyConfigured = true;
        }
        ConfigurationServiceProvider.instance = instance;
    }

    public static synchronized ConfigurationService overrideCurrent(Consumer<ConfigurationServiceOverrider> overrider) {
        if (overrider != null) {
            ConfigurationServiceOverrider toOverride = new ConfigurationServiceOverrider(ConfigurationServiceProvider.instance());
            overrider.accept(toOverride);
            ConfigurationServiceProvider.set(toOverride.build(), true);
        }
        return ConfigurationServiceProvider.instance();
    }

    public static synchronized void setDefault(ConfigurationService defaultConfigurationService) {
        ConfigurationServiceProvider.defaultConfigurationService = defaultConfigurationService;
    }

    static synchronized ConfigurationService getDefault() {
        return defaultConfigurationService;
    }

    public static synchronized void reset() {
        defaultConfigurationService = ConfigurationServiceProvider.createDefault();
        instance = null;
        alreadyConfigured = false;
    }

    static ConfigurationService createDefault() {
        return new BaseConfigurationService(Utils.VERSION);
    }

    static {
        defaultConfigurationService = ConfigurationServiceProvider.createDefault();
        alreadyConfigured = false;
    }
}

