/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.client.Config;
import io.javaoperatorsdk.operator.api.config.BaseConfigurationService;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.InformerStoppedHandler;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.config.ResourceClassResolver;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class ConfigurationServiceOverrider {
    private final ConfigurationService original;
    private Metrics metrics;
    private Config clientConfig;
    private Boolean checkCR;
    private Integer concurrentReconciliationThreads;
    private Integer minConcurrentReconciliationThreads;
    private Integer concurrentWorkflowExecutorThreads;
    private Integer minConcurrentWorkflowExecutorThreads;
    private Cloner cloner;
    private Integer timeoutSeconds;
    private Boolean closeClientOnStop;
    private ObjectMapper objectMapper;
    private ExecutorService executorService;
    private ExecutorService workflowExecutorService;
    private LeaderElectionConfiguration leaderElectionConfiguration;
    private InformerStoppedHandler informerStoppedHandler;
    private Boolean stopOnInformerErrorDuringStartup;
    private Duration cacheSyncTimeout;
    private ResourceClassResolver resourceClassResolver;

    ConfigurationServiceOverrider(ConfigurationService original) {
        this.original = original;
    }

    public ConfigurationServiceOverrider withClientConfiguration(Config configuration) {
        this.clientConfig = configuration;
        return this;
    }

    public ConfigurationServiceOverrider checkingCRDAndValidateLocalModel(boolean check) {
        this.checkCR = check;
        return this;
    }

    public ConfigurationServiceOverrider withConcurrentReconciliationThreads(int threadNumber) {
        this.concurrentReconciliationThreads = threadNumber;
        return this;
    }

    public ConfigurationServiceOverrider withConcurrentWorkflowExecutorThreads(int threadNumber) {
        this.concurrentWorkflowExecutorThreads = threadNumber;
        return this;
    }

    public ConfigurationServiceOverrider withMinConcurrentReconciliationThreads(int threadNumber) {
        this.minConcurrentReconciliationThreads = threadNumber;
        return this;
    }

    public ConfigurationServiceOverrider withMinConcurrentWorkflowExecutorThreads(int threadNumber) {
        this.minConcurrentWorkflowExecutorThreads = threadNumber;
        return this;
    }

    public ConfigurationServiceOverrider withResourceCloner(Cloner cloner) {
        this.cloner = cloner;
        return this;
    }

    public ConfigurationServiceOverrider withTerminationTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public ConfigurationServiceOverrider withMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public ConfigurationServiceOverrider withCloseClientOnStop(boolean close) {
        this.closeClientOnStop = close;
        return this;
    }

    public ConfigurationServiceOverrider withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationServiceOverrider withWorkflowExecutorService(ExecutorService workflowExecutorService) {
        this.workflowExecutorService = workflowExecutorService;
        return this;
    }

    public ConfigurationServiceOverrider withObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public ConfigurationServiceOverrider withLeaderElectionConfiguration(LeaderElectionConfiguration leaderElectionConfiguration) {
        this.leaderElectionConfiguration = leaderElectionConfiguration;
        return this;
    }

    public ConfigurationServiceOverrider withInformerStoppedHandler(InformerStoppedHandler handler) {
        this.informerStoppedHandler = handler;
        return this;
    }

    public ConfigurationServiceOverrider withStopOnInformerErrorDuringStartup(boolean stopOnInformerErrorDuringStartup) {
        this.stopOnInformerErrorDuringStartup = stopOnInformerErrorDuringStartup;
        return this;
    }

    public ConfigurationServiceOverrider withCacheSyncTimeout(Duration cacheSyncTimeout) {
        this.cacheSyncTimeout = cacheSyncTimeout;
        return this;
    }

    public ConfigurationServiceOverrider withResourceClassResolver(ResourceClassResolver resourceClassResolver) {
        this.resourceClassResolver = resourceClassResolver;
        return this;
    }

    public ConfigurationService build() {
        return new BaseConfigurationService(this.original.getVersion(), this.cloner, this.objectMapper){

            @Override
            public Set<String> getKnownReconcilerNames() {
                return ConfigurationServiceOverrider.this.original.getKnownReconcilerNames();
            }

            @Override
            public Config getClientConfiguration() {
                return ConfigurationServiceOverrider.this.clientConfig != null ? ConfigurationServiceOverrider.this.clientConfig : ConfigurationServiceOverrider.this.original.getClientConfiguration();
            }

            @Override
            public boolean checkCRDAndValidateLocalModel() {
                return ConfigurationServiceOverrider.this.checkCR != null ? ConfigurationServiceOverrider.this.checkCR.booleanValue() : ConfigurationServiceOverrider.this.original.checkCRDAndValidateLocalModel();
            }

            @Override
            public int concurrentReconciliationThreads() {
                return ConfigurationServiceOverrider.this.concurrentReconciliationThreads != null ? ConfigurationServiceOverrider.this.concurrentReconciliationThreads.intValue() : ConfigurationServiceOverrider.this.original.concurrentReconciliationThreads();
            }

            @Override
            public int concurrentWorkflowExecutorThreads() {
                return ConfigurationServiceOverrider.this.concurrentWorkflowExecutorThreads != null ? ConfigurationServiceOverrider.this.concurrentWorkflowExecutorThreads.intValue() : ConfigurationServiceOverrider.this.original.concurrentWorkflowExecutorThreads();
            }

            @Override
            public int minConcurrentReconciliationThreads() {
                return ConfigurationServiceOverrider.this.minConcurrentReconciliationThreads != null ? ConfigurationServiceOverrider.this.minConcurrentReconciliationThreads.intValue() : ConfigurationServiceOverrider.this.original.minConcurrentReconciliationThreads();
            }

            @Override
            public int minConcurrentWorkflowExecutorThreads() {
                return ConfigurationServiceOverrider.this.minConcurrentWorkflowExecutorThreads != null ? ConfigurationServiceOverrider.this.minConcurrentWorkflowExecutorThreads.intValue() : ConfigurationServiceOverrider.this.original.minConcurrentWorkflowExecutorThreads();
            }

            @Override
            public int getTerminationTimeoutSeconds() {
                return ConfigurationServiceOverrider.this.timeoutSeconds != null ? ConfigurationServiceOverrider.this.timeoutSeconds.intValue() : ConfigurationServiceOverrider.this.original.getTerminationTimeoutSeconds();
            }

            @Override
            public Metrics getMetrics() {
                return ConfigurationServiceOverrider.this.metrics != null ? ConfigurationServiceOverrider.this.metrics : ConfigurationServiceOverrider.this.original.getMetrics();
            }

            @Override
            public boolean closeClientOnStop() {
                return ConfigurationServiceOverrider.this.closeClientOnStop != null ? ConfigurationServiceOverrider.this.closeClientOnStop.booleanValue() : ConfigurationServiceOverrider.this.original.closeClientOnStop();
            }

            @Override
            public ExecutorService getExecutorService() {
                return ConfigurationServiceOverrider.this.executorService != null ? ConfigurationServiceOverrider.this.executorService : super.getExecutorService();
            }

            @Override
            public ExecutorService getWorkflowExecutorService() {
                return ConfigurationServiceOverrider.this.workflowExecutorService != null ? ConfigurationServiceOverrider.this.workflowExecutorService : super.getWorkflowExecutorService();
            }

            @Override
            public ObjectMapper getObjectMapper() {
                return ConfigurationServiceOverrider.this.objectMapper != null ? ConfigurationServiceOverrider.this.objectMapper : ConfigurationServiceOverrider.this.original.getObjectMapper();
            }

            @Override
            public Optional<LeaderElectionConfiguration> getLeaderElectionConfiguration() {
                return ConfigurationServiceOverrider.this.leaderElectionConfiguration != null ? Optional.of(ConfigurationServiceOverrider.this.leaderElectionConfiguration) : ConfigurationServiceOverrider.this.original.getLeaderElectionConfiguration();
            }

            @Override
            public Optional<InformerStoppedHandler> getInformerStoppedHandler() {
                return ConfigurationServiceOverrider.this.informerStoppedHandler != null ? Optional.of(ConfigurationServiceOverrider.this.informerStoppedHandler) : ConfigurationServiceOverrider.this.original.getInformerStoppedHandler();
            }

            @Override
            public boolean stopOnInformerErrorDuringStartup() {
                return ConfigurationServiceOverrider.this.stopOnInformerErrorDuringStartup != null ? ConfigurationServiceOverrider.this.stopOnInformerErrorDuringStartup.booleanValue() : super.stopOnInformerErrorDuringStartup();
            }

            @Override
            public Duration cacheSyncTimeout() {
                return ConfigurationServiceOverrider.this.cacheSyncTimeout != null ? ConfigurationServiceOverrider.this.cacheSyncTimeout : super.cacheSyncTimeout();
            }

            @Override
            public ResourceClassResolver getResourceClassResolver() {
                return ConfigurationServiceOverrider.this.resourceClassResolver != null ? ConfigurationServiceOverrider.this.resourceClassResolver : super.getResourceClassResolver();
            }
        };
    }

    @Deprecated(since="2.2.0")
    public static ConfigurationServiceOverrider override(ConfigurationService original) {
        return new ConfigurationServiceOverrider(original);
    }
}

