/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.informers.cache.ItemStore;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.AbstractConfigurationService;
import io.javaoperatorsdk.operator.api.config.AnnotationConfigurable;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationServiceProvider;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ResolvedControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.config.dependent.DependentResourceSpec;
import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.MaxReconciliationInterval;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Dependent;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Condition;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilter;
import io.javaoperatorsdk.operator.processing.event.source.controller.ResourceEventFilters;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import io.javaoperatorsdk.operator.processing.retry.Retry;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseConfigurationService
extends AbstractConfigurationService {
    private static final String LOGGER_NAME = "Default ConfigurationService implementation";
    private static final Logger logger = LoggerFactory.getLogger((String)"Default ConfigurationService implementation");

    public BaseConfigurationService(Version version) {
        super(version);
    }

    public BaseConfigurationService(Version version, Cloner cloner, ObjectMapper mapper) {
        super(version, cloner, mapper);
    }

    public BaseConfigurationService(Version version, Cloner cloner) {
        super(version, cloner);
    }

    public BaseConfigurationService() {
        this(Utils.VERSION);
    }

    @Override
    protected void logMissingReconcilerWarning(String reconcilerKey, String reconcilersNameMessage) {
        logger.warn("Configuration for reconciler '{}' was not found. {}", (Object)reconcilerKey, (Object)reconcilersNameMessage);
    }

    public String getLoggerName() {
        return LOGGER_NAME;
    }

    protected Logger getLogger() {
        return logger;
    }

    @Override
    public <R extends HasMetadata> ControllerConfiguration<R> getConfigurationFor(Reconciler<R> reconciler) {
        ControllerConfiguration<R> config = super.getConfigurationFor(reconciler);
        if (config == null) {
            if (this.createIfNeeded()) {
                config = this.configFor(reconciler);
                this.register(config);
                this.getLogger().info("Created configuration for reconciler {} with name {}", (Object)reconciler.getClass().getName(), (Object)config.getName());
            }
        } else {
            String newControllerClassName = reconciler.getClass().getCanonicalName();
            if (!config.getAssociatedReconcilerClassName().equals(newControllerClassName)) {
                this.throwExceptionOnNameCollision(newControllerClassName, config);
            }
        }
        return config;
    }

    protected <P extends HasMetadata> ControllerConfiguration<P> configFor(Reconciler<P> reconciler) {
        io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration annotation = reconciler.getClass().getAnnotation(io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration.class);
        if (annotation == null) {
            throw new OperatorException("Missing mandatory @" + io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration.class.getSimpleName() + " annotation for reconciler:  " + reconciler);
        }
        Class<?> reconcilerClass = reconciler.getClass();
        Class resourceClass = ConfigurationServiceProvider.instance().getResourceClassResolver().getResourceClass(reconcilerClass);
        String name = ReconcilerUtils.getNameFor(reconciler);
        Boolean generationAware = BaseConfigurationService.valueOrDefault(annotation, io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration::generationAwareEventProcessing, true);
        String associatedReconcilerClass = ResolvedControllerConfiguration.getAssociatedReconcilerClassName(reconciler.getClass());
        String context = Utils.contextFor(name);
        Class<? extends Retry> retryClass = annotation.retry();
        Retry retry = Utils.instantiateAndConfigureIfNeeded(retryClass, Retry.class, context, BaseConfigurationService.configuratorFor(Retry.class, reconciler));
        Class<? extends RateLimiter> rateLimiterClass = annotation.rateLimiter();
        RateLimiter rateLimiter = Utils.instantiateAndConfigureIfNeeded(rateLimiterClass, RateLimiter.class, context, BaseConfigurationService.configuratorFor(RateLimiter.class, reconciler));
        MaxReconciliationInterval reconciliationInterval = annotation.maxReconciliationInterval();
        long interval = -1L;
        TimeUnit timeUnit = null;
        if (reconciliationInterval != null && reconciliationInterval.interval() > 0L) {
            interval = reconciliationInterval.interval();
            timeUnit = reconciliationInterval.timeUnit();
        }
        ResolvedControllerConfiguration config = new ResolvedControllerConfiguration(resourceClass, name, generationAware, associatedReconcilerClass, retry, rateLimiter, ResolvedControllerConfiguration.getMaxReconciliationInterval(interval, timeUnit), Utils.instantiate(annotation.onAddFilter(), OnAddFilter.class, context), Utils.instantiate(annotation.onUpdateFilter(), OnUpdateFilter.class, context), Utils.instantiate(annotation.genericFilter(), GenericFilter.class, context), Set.of(BaseConfigurationService.valueOrDefault(annotation, io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration::namespaces, (String[])Constants.DEFAULT_NAMESPACES_SET.toArray(String[]::new))), BaseConfigurationService.valueOrDefault(annotation, io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration::finalizerName, ""), BaseConfigurationService.valueOrDefault(annotation, io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration::labelSelector, ""), null, Utils.instantiate(annotation.itemStore(), ItemStore.class, context));
        ResourceEventFilter<P> answer = BaseConfigurationService.deprecatedEventFilter(annotation);
        config.setEventFilter(answer != null ? answer : ResourceEventFilters.passthrough());
        List<DependentResourceSpec> specs = BaseConfigurationService.dependentResources(annotation, config);
        config.setDependentResources(specs);
        return config;
    }

    private static <P extends HasMetadata> ResourceEventFilter<P> deprecatedEventFilter(io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration annotation) {
        Class[] filterTypes;
        ResourceEventFilter answer = null;
        for (Class filterType : filterTypes = (Class[])BaseConfigurationService.valueOrDefault(annotation, io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration::eventFilters, new Object[0])) {
            try {
                ResourceEventFilter filter = (ResourceEventFilter)filterType.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (answer == null) {
                    answer = filter;
                    continue;
                }
                answer = answer.and(filter);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return answer;
    }

    private static List<DependentResourceSpec> dependentResources(io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration annotation, ControllerConfiguration<?> parent) {
        Dependent[] dependents = BaseConfigurationService.valueOrDefault(annotation, io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration::dependents, new Dependent[0]);
        if (dependents.length == 0) {
            return Collections.emptyList();
        }
        LinkedHashMap specsMap = new LinkedHashMap(dependents.length);
        for (Dependent dependent : dependents) {
            Class<? extends DependentResource> dependentType = dependent.type();
            String dependentName = BaseConfigurationService.getName(dependent.name(), dependentType);
            DependentResourceSpec spec = (DependentResourceSpec)specsMap.get(dependentName);
            if (spec != null) {
                throw new IllegalArgumentException("A DependentResource named '" + dependentName + "' already exists: " + spec);
            }
            String name = parent.getName();
            String eventSourceName = dependent.useEventSourceWithName();
            eventSourceName = "".equals(eventSourceName) ? null : eventSourceName;
            String context = Utils.contextFor(name, dependentType, null);
            spec = new DependentResourceSpec(dependentType, dependentName, Set.of(dependent.dependsOn()), Utils.instantiate(dependent.readyPostcondition(), Condition.class, context), Utils.instantiate(dependent.reconcilePrecondition(), Condition.class, context), Utils.instantiate(dependent.deletePostcondition(), Condition.class, context), eventSourceName);
            specsMap.put(dependentName, spec);
        }
        return specsMap.values().stream().collect(Collectors.toUnmodifiableList());
    }

    protected boolean createIfNeeded() {
        return true;
    }

    @Override
    public boolean checkCRDAndValidateLocalModel() {
        return Utils.shouldCheckCRDAndValidateLocalModel();
    }

    private static <T> T valueOrDefault(io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration controllerConfiguration, Function<io.javaoperatorsdk.operator.api.reconciler.ControllerConfiguration, T> mapper, T defaultValue) {
        if (controllerConfiguration == null) {
            return defaultValue;
        }
        return mapper.apply(controllerConfiguration);
    }

    private static String getName(String name, Class<? extends DependentResource> dependentType) {
        if (name.isBlank()) {
            name = DependentResource.defaultNameFor(dependentType);
        }
        return name;
    }

    private static <T> Utils.Configurator<T> configuratorFor(Class<T> instanceType, Reconciler<?> reconciler) {
        return instance -> BaseConfigurationService.configureFromAnnotatedReconciler(instance, reconciler);
    }

    private static void configureFromAnnotatedReconciler(Object instance, Reconciler<?> reconciler) {
        if (instance instanceof AnnotationConfigurable) {
            AnnotationConfigurable configurable = (AnnotationConfigurable)instance;
            Class<?> configurationClass = Utils.getFirstTypeArgumentFromSuperClassOrInterface(instance.getClass(), AnnotationConfigurable.class);
            Object configAnnotation = reconciler.getClass().getAnnotation(configurationClass);
            if (configAnnotation != null) {
                configurable.initFrom(configAnnotation);
            }
        }
    }
}

