/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.ReconcilerUtils;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.Version;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class AbstractConfigurationService
implements ConfigurationService {
    private final Map<String, ControllerConfiguration> configurations = new ConcurrentHashMap<String, ControllerConfiguration>();
    private final Version version;
    private Cloner cloner;
    private ObjectMapper mapper;

    public AbstractConfigurationService(Version version) {
        this(version, null, null);
    }

    public AbstractConfigurationService(Version version, Cloner cloner) {
        this(version, cloner, null);
    }

    public AbstractConfigurationService(Version version, Cloner cloner, ObjectMapper mapper) {
        this.version = version;
        this.init(cloner, mapper);
    }

    protected void init(Cloner cloner, ObjectMapper mapper) {
        this.cloner = cloner != null ? cloner : ConfigurationService.super.getResourceCloner();
        this.mapper = mapper != null ? mapper : ConfigurationService.super.getObjectMapper();
    }

    protected <R extends HasMetadata> void register(ControllerConfiguration<R> config) {
        this.put(config, true);
    }

    protected <R extends HasMetadata> void replace(ControllerConfiguration<R> config) {
        this.put(config, false);
    }

    private <R extends HasMetadata> void put(ControllerConfiguration<R> config, boolean failIfExisting) {
        ControllerConfiguration existing;
        String name = config.getName();
        if (failIfExisting && (existing = this.configurations.get(name)) != null) {
            this.throwExceptionOnNameCollision(config.getAssociatedReconcilerClassName(), existing);
        }
        this.configurations.put(name, config);
    }

    protected <R extends HasMetadata> void throwExceptionOnNameCollision(String newReconcilerClassName, ControllerConfiguration<R> existing) {
        throw new IllegalArgumentException("Reconciler name '" + existing.getName() + "' is used by both " + existing.getAssociatedReconcilerClassName() + " and " + newReconcilerClassName);
    }

    @Override
    public <R extends HasMetadata> ControllerConfiguration<R> getConfigurationFor(Reconciler<R> reconciler) {
        String key = this.keyFor(reconciler);
        ControllerConfiguration configuration = this.configurations.get(key);
        if (configuration == null) {
            this.logMissingReconcilerWarning(key, this.getReconcilersNameMessage());
        }
        return configuration;
    }

    protected void logMissingReconcilerWarning(String reconcilerKey, String reconcilersNameMessage) {
        log.warn("Cannot find reconciler named '{}'. {}", (Object)reconcilerKey, (Object)reconcilersNameMessage);
    }

    private String getReconcilersNameMessage() {
        return "Known reconcilers: " + this.getKnownReconcilerNames().stream().reduce((s, s2) -> s + ", " + s2).orElse("None") + ".";
    }

    protected <R extends HasMetadata> String keyFor(Reconciler<R> reconciler) {
        return ReconcilerUtils.getNameFor(reconciler);
    }

    protected ControllerConfiguration getFor(String reconcilerName) {
        return this.configurations.get(reconcilerName);
    }

    protected Stream<ControllerConfiguration> controllerConfigurations() {
        return this.configurations.values().stream();
    }

    @Override
    public Set<String> getKnownReconcilerNames() {
        return this.configurations.keySet();
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    public Cloner getResourceCloner() {
        return this.cloner;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.mapper;
    }
}

