/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.dependent;

import io.debezium.operator.DebeziumServer;
import io.debezium.operator.VersionProvider;
import io.debezium.operator.model.DebeziumServerSpec;
import io.debezium.operator.model.Quarkus;
import io.debezium.operator.model.Runtime;
import io.debezium.operator.model.Storage;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class DeploymentDependent
extends CRUDKubernetesDependentResource<Deployment, DebeziumServer> {
    public static final String DEFAULT_IMAGE = "quay.io/debezium/server";
    public static final String CONFIG_VOLUME_NAME = "ds-config";
    public static final String CONFIG_FILE_NAME = "application.properties";
    public static final String CONFIG_FILE_PATH = "/debezium/conf/application.properties";
    public static final String DATA_VOLUME_NAME = "ds-data";
    public static final String DATA_VOLUME_PATH = "/debezium/data";
    public static final String EXTERNAL_VOLUME_PATH = "/debezium/external-configuration/%s";
    public static final int DEFAULT_HTTP_PORT = 8080;
    private static final String CONFIG_MD5_ANNOTATION = "debezium.io/server-config-md5";
    @ConfigProperty(name="debezium.image", defaultValue="quay.io/debezium/server")
    String defaultImage;
    @Inject
    VersionProvider version;

    public DeploymentDependent() {
        super(Deployment.class);
    }

    private String getTaggedImage(DebeziumServer primary) {
        Object image = ((DebeziumServerSpec)primary.getSpec()).getImage();
        if (image == null) {
            image = this.defaultImage + ":" + this.version.getImageTag(primary);
        }
        return image;
    }

    protected Deployment desired(DebeziumServer primary, Context<DebeziumServer> context) {
        String name = primary.getMetadata().getName();
        String image = this.getTaggedImage(primary);
        Map<String, String> labels = Map.of("app", name);
        Map<String, String> annotations = Map.of(CONFIG_MD5_ANNOTATION, primary.asConfiguration().md5Sum());
        Volume dataVolume = this.desiredDataVolume(primary);
        String sa = context.getSecondaryResource(ServiceAccount.class).map(r -> r.getMetadata().getName()).orElseThrow();
        Quarkus quarkus = ((DebeziumServerSpec)primary.getSpec()).getQuarkus();
        Object probePort = quarkus.getConfig().getProps().getOrDefault("http.port", 8080);
        Deployment deployment = ((DeploymentBuilder)((DeploymentBuilder)new DeploymentBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(primary.getMetadata().getNamespace())).withName(name)).withLabels(labels)).withAnnotations(annotations)).build())).withSpec(((DeploymentSpecBuilder)((DeploymentSpecBuilder)new DeploymentSpecBuilder().withSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels(labels)).build())).withTemplate(((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withLabels(labels)).withAnnotations(annotations)).build())).withSpec(((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withServiceAccountName(sa)).addToVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(CONFIG_VOLUME_NAME)).withConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(name)).build())).build()})).addToVolumes(new Volume[]{dataVolume})).addToContainers(new Container[]{((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName(name)).withImage(image)).withLivenessProbe(((ProbeBuilder)new ProbeBuilder().withHttpGet(((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath("/q/health/live")).withPort(new IntOrString(probePort))).build())).build())).withReadinessProbe(((ProbeBuilder)new ProbeBuilder().withHttpGet(((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath("/q/health/ready")).withPort(new IntOrString(probePort))).build())).build())).withPorts(new ContainerPort[]{((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("http")).withProtocol("TCP")).withContainerPort(Integer.valueOf(8080))).build()})).addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(CONFIG_VOLUME_NAME)).withMountPath(CONFIG_FILE_PATH)).withSubPath(CONFIG_FILE_NAME)).build()})).addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(DATA_VOLUME_NAME)).withMountPath(DATA_VOLUME_PATH)).build()})).build()})).build())).build())).build())).build();
        this.addExternalEnvVariables(primary, deployment);
        this.addExternalVolumes(primary, deployment);
        return deployment;
    }

    private void addExternalEnvVariables(DebeziumServer primary, Deployment deployment) {
        Runtime config = ((DebeziumServerSpec)primary.getSpec()).getRuntime();
        List containers = deployment.getSpec().getTemplate().getSpec().getContainers();
        containers.forEach(container -> container.getEnvFrom().addAll(config.getEnv()));
    }

    private void addExternalVolumes(DebeziumServer primary, Deployment deployment) {
        Runtime config = ((DebeziumServerSpec)primary.getSpec()).getRuntime();
        List volumes = deployment.getSpec().getTemplate().getSpec().getVolumes();
        List containers = deployment.getSpec().getTemplate().getSpec().getContainers();
        List<VolumeMount> volumeMounts = config.getVolumes().stream().map(volume -> ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volume.getName())).withMountPath(EXTERNAL_VOLUME_PATH.formatted(volume.getName()))).withReadOnly()).build()).toList();
        volumes.addAll(config.getVolumes());
        containers.forEach(container -> container.getVolumeMounts().addAll(volumeMounts));
    }

    private Volume desiredDataVolume(DebeziumServer primary) {
        Storage storageConfig = ((DebeziumServerSpec)primary.getSpec()).getStorage();
        VolumeBuilder builder = (VolumeBuilder)new VolumeBuilder().withName(DATA_VOLUME_NAME);
        switch (storageConfig.getType()) {
            case EPHEMERAL: {
                builder.withEmptyDir(new EmptyDirVolumeSourceBuilder().build());
                break;
            }
            case PERSISTENT: {
                builder.withPersistentVolumeClaim(((PersistentVolumeClaimVolumeSourceBuilder)new PersistentVolumeClaimVolumeSourceBuilder().withClaimName(storageConfig.getClaimName())).build());
            }
        }
        return builder.build();
    }
}

