/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.debezium.operator.api.config.ConfigMappable;
import io.debezium.operator.api.config.ConfigMapping;
import io.debezium.operator.api.model.ConfigProperties;
import io.debezium.operator.api.model.source.Offset;
import io.debezium.operator.api.model.source.SchemaHistory;

public class Source
implements ConfigMappable {
    @JsonPropertyDescription(value="Fully qualified name of source connector Java class.")
    @JsonProperty(value="class", required=true)
    private String sourceClass;
    @JsonPropertyDescription(value="Offset store configuration")
    private Offset offset = new Offset();
    @JsonPropertyDescription(value="Schema history store configuration")
    private SchemaHistory schemaHistory = new SchemaHistory();
    @JsonPropertyDescription(value="Source connector configuration properties.")
    private ConfigProperties config = new ConfigProperties();

    public String getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(String clazz) {
        this.sourceClass = clazz;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public SchemaHistory getSchemaHistory() {
        return this.schemaHistory;
    }

    public void setSchemaHistory(SchemaHistory schemaHistory) {
        this.schemaHistory = schemaHistory;
    }

    public ConfigProperties getConfig() {
        return this.config;
    }

    public void setConfig(ConfigProperties config) {
        this.config = config;
    }

    @Override
    public ConfigMapping asConfiguration() {
        return ConfigMapping.empty().put("connector.class", this.sourceClass).putAll(this.config).putAll("offset", this.offset).putAll("schema.history.internal", this.schemaHistory);
    }
}

