/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.source;

import io.debezium.operator.api.model.source.Offset;
import io.debezium.operator.api.model.source.storage.CustomStore;
import io.debezium.operator.api.model.source.storage.CustomStoreBuilder;
import io.debezium.operator.api.model.source.storage.CustomStoreFluent;
import io.debezium.operator.api.model.source.storage.offset.FileOffsetStore;
import io.debezium.operator.api.model.source.storage.offset.FileOffsetStoreBuilder;
import io.debezium.operator.api.model.source.storage.offset.FileOffsetStoreFluent;
import io.debezium.operator.api.model.source.storage.offset.InMemoryOffsetStore;
import io.debezium.operator.api.model.source.storage.offset.InMemoryOffsetStoreBuilder;
import io.debezium.operator.api.model.source.storage.offset.InMemoryOffsetStoreFluent;
import io.debezium.operator.api.model.source.storage.offset.RedisOffsetStore;
import io.debezium.operator.api.model.source.storage.offset.RedisOffsetStoreBuilder;
import io.debezium.operator.api.model.source.storage.offset.RedisOffsetStoreFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class OffsetFluent<A extends OffsetFluent<A>>
extends BaseFluent<A> {
    private FileOffsetStoreBuilder file;
    private InMemoryOffsetStoreBuilder memory;
    private RedisOffsetStoreBuilder redis;
    private CustomStoreBuilder store;
    private long flushMs;

    public OffsetFluent() {
    }

    public OffsetFluent(Offset instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Offset instance) {
        Offset offset = instance = instance != null ? instance : new Offset();
        if (instance != null) {
            this.withFile(instance.getFile());
            this.withMemory(instance.getMemory());
            this.withRedis(instance.getRedis());
            this.withStore(instance.getStore());
            this.withFlushMs(instance.getFlushMs());
        }
    }

    public FileOffsetStore buildFile() {
        return this.file != null ? this.file.build() : null;
    }

    public A withFile(FileOffsetStore file) {
        this._visitables.remove((Object)"file");
        if (file != null) {
            this.file = new FileOffsetStoreBuilder(file);
            this._visitables.get((Object)"file").add(this.file);
        } else {
            this.file = null;
            this._visitables.get((Object)"file").remove((Object)this.file);
        }
        return (A)((Object)this);
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public FileNested<A> withNewFile() {
        return new FileNested(null);
    }

    public FileNested<A> withNewFileLike(FileOffsetStore item) {
        return new FileNested(item);
    }

    public FileNested<A> editFile() {
        return this.withNewFileLike(Optional.ofNullable(this.buildFile()).orElse(null));
    }

    public FileNested<A> editOrNewFile() {
        return this.withNewFileLike(Optional.ofNullable(this.buildFile()).orElse(new FileOffsetStoreBuilder().build()));
    }

    public FileNested<A> editOrNewFileLike(FileOffsetStore item) {
        return this.withNewFileLike(Optional.ofNullable(this.buildFile()).orElse(item));
    }

    public InMemoryOffsetStore buildMemory() {
        return this.memory != null ? this.memory.build() : null;
    }

    public A withMemory(InMemoryOffsetStore memory) {
        this._visitables.remove((Object)"memory");
        if (memory != null) {
            this.memory = new InMemoryOffsetStoreBuilder(memory);
            this._visitables.get((Object)"memory").add(this.memory);
        } else {
            this.memory = null;
            this._visitables.get((Object)"memory").remove((Object)this.memory);
        }
        return (A)((Object)this);
    }

    public boolean hasMemory() {
        return this.memory != null;
    }

    public MemoryNested<A> withNewMemory() {
        return new MemoryNested(null);
    }

    public MemoryNested<A> withNewMemoryLike(InMemoryOffsetStore item) {
        return new MemoryNested(item);
    }

    public MemoryNested<A> editMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(null));
    }

    public MemoryNested<A> editOrNewMemory() {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(new InMemoryOffsetStoreBuilder().build()));
    }

    public MemoryNested<A> editOrNewMemoryLike(InMemoryOffsetStore item) {
        return this.withNewMemoryLike(Optional.ofNullable(this.buildMemory()).orElse(item));
    }

    public RedisOffsetStore buildRedis() {
        return this.redis != null ? this.redis.build() : null;
    }

    public A withRedis(RedisOffsetStore redis) {
        this._visitables.remove((Object)"redis");
        if (redis != null) {
            this.redis = new RedisOffsetStoreBuilder(redis);
            this._visitables.get((Object)"redis").add(this.redis);
        } else {
            this.redis = null;
            this._visitables.get((Object)"redis").remove((Object)this.redis);
        }
        return (A)((Object)this);
    }

    public boolean hasRedis() {
        return this.redis != null;
    }

    public RedisNested<A> withNewRedis() {
        return new RedisNested(null);
    }

    public RedisNested<A> withNewRedisLike(RedisOffsetStore item) {
        return new RedisNested(item);
    }

    public RedisNested<A> editRedis() {
        return this.withNewRedisLike(Optional.ofNullable(this.buildRedis()).orElse(null));
    }

    public RedisNested<A> editOrNewRedis() {
        return this.withNewRedisLike(Optional.ofNullable(this.buildRedis()).orElse(new RedisOffsetStoreBuilder().build()));
    }

    public RedisNested<A> editOrNewRedisLike(RedisOffsetStore item) {
        return this.withNewRedisLike(Optional.ofNullable(this.buildRedis()).orElse(item));
    }

    public CustomStore buildStore() {
        return this.store != null ? this.store.build() : null;
    }

    public A withStore(CustomStore store) {
        this._visitables.remove((Object)"store");
        if (store != null) {
            this.store = new CustomStoreBuilder(store);
            this._visitables.get((Object)"store").add(this.store);
        } else {
            this.store = null;
            this._visitables.get((Object)"store").remove((Object)this.store);
        }
        return (A)((Object)this);
    }

    public boolean hasStore() {
        return this.store != null;
    }

    public StoreNested<A> withNewStore() {
        return new StoreNested(null);
    }

    public StoreNested<A> withNewStoreLike(CustomStore item) {
        return new StoreNested(item);
    }

    public StoreNested<A> editStore() {
        return this.withNewStoreLike(Optional.ofNullable(this.buildStore()).orElse(null));
    }

    public StoreNested<A> editOrNewStore() {
        return this.withNewStoreLike(Optional.ofNullable(this.buildStore()).orElse(new CustomStoreBuilder().build()));
    }

    public StoreNested<A> editOrNewStoreLike(CustomStore item) {
        return this.withNewStoreLike(Optional.ofNullable(this.buildStore()).orElse(item));
    }

    public long getFlushMs() {
        return this.flushMs;
    }

    public A withFlushMs(long flushMs) {
        this.flushMs = flushMs;
        return (A)((Object)this);
    }

    public boolean hasFlushMs() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OffsetFluent that = (OffsetFluent)((Object)o);
        if (!Objects.equals((Object)this.file, (Object)that.file)) {
            return false;
        }
        if (!Objects.equals((Object)this.memory, (Object)that.memory)) {
            return false;
        }
        if (!Objects.equals((Object)this.redis, (Object)that.redis)) {
            return false;
        }
        if (!Objects.equals((Object)this.store, (Object)that.store)) {
            return false;
        }
        return this.flushMs == that.flushMs;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.file, this.memory, this.redis, this.store, this.flushMs, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.file != null) {
            sb.append("file:");
            sb.append(this.file + ",");
        }
        if (this.memory != null) {
            sb.append("memory:");
            sb.append(this.memory + ",");
        }
        if (this.redis != null) {
            sb.append("redis:");
            sb.append(this.redis + ",");
        }
        if (this.store != null) {
            sb.append("store:");
            sb.append(this.store + ",");
        }
        sb.append("flushMs:");
        sb.append(this.flushMs);
        sb.append("}");
        return sb.toString();
    }

    public class FileNested<N>
    extends FileOffsetStoreFluent<FileNested<N>>
    implements Nested<N> {
        FileOffsetStoreBuilder builder;

        FileNested(FileOffsetStore item) {
            this.builder = new FileOffsetStoreBuilder(this, item);
        }

        public N and() {
            return (N)OffsetFluent.this.withFile(this.builder.build());
        }

        public N endFile() {
            return this.and();
        }
    }

    public class MemoryNested<N>
    extends InMemoryOffsetStoreFluent<MemoryNested<N>>
    implements Nested<N> {
        InMemoryOffsetStoreBuilder builder;

        MemoryNested(InMemoryOffsetStore item) {
            this.builder = new InMemoryOffsetStoreBuilder(this, item);
        }

        public N and() {
            return (N)OffsetFluent.this.withMemory(this.builder.build());
        }

        public N endMemory() {
            return this.and();
        }
    }

    public class RedisNested<N>
    extends RedisOffsetStoreFluent<RedisNested<N>>
    implements Nested<N> {
        RedisOffsetStoreBuilder builder;

        RedisNested(RedisOffsetStore item) {
            this.builder = new RedisOffsetStoreBuilder(this, item);
        }

        public N and() {
            return (N)OffsetFluent.this.withRedis(this.builder.build());
        }

        public N endRedis() {
            return this.and();
        }
    }

    public class StoreNested<N>
    extends CustomStoreFluent<StoreNested<N>>
    implements Nested<N> {
        CustomStoreBuilder builder;

        StoreNested(CustomStore item) {
            this.builder = new CustomStoreBuilder(this, item);
        }

        public N and() {
            return (N)OffsetFluent.this.withStore(this.builder.build());
        }

        public N endStore() {
            return this.and();
        }
    }
}

