/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent.kubernetes;

import io.javaoperatorsdk.operator.api.reconciler.Constants;
import io.javaoperatorsdk.operator.api.reconciler.ResourceDiscriminator;
import io.javaoperatorsdk.operator.processing.event.source.filter.GenericFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnAddFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnDeleteFilter;
import io.javaoperatorsdk.operator.processing.event.source.filter.OnUpdateFilter;
import java.util.Optional;
import java.util.Set;

public class KubernetesDependentResourceConfig<R> {
    public static final boolean DEFAULT_CREATE_RESOURCE_ONLY_IF_NOT_EXISTING_WITH_SSA = true;
    private Set<String> namespaces;
    private String labelSelector;
    private final boolean namespacesWereConfigured;
    private final boolean createResourceOnlyIfNotExistingWithSSA;
    private final ResourceDiscriminator<R, ?> resourceDiscriminator;
    private final Boolean useSSA;
    private final OnAddFilter<R> onAddFilter;
    private final OnUpdateFilter<R> onUpdateFilter;
    private final OnDeleteFilter<R> onDeleteFilter;
    private final GenericFilter<R> genericFilter;

    public KubernetesDependentResourceConfig() {
        this(Constants.SAME_AS_CONTROLLER_NAMESPACES_SET, "", true, true, null, null, null, null, null, null);
    }

    public KubernetesDependentResourceConfig(Set<String> namespaces, String labelSelector, boolean configuredNS, boolean createResourceOnlyIfNotExistingWithSSA, ResourceDiscriminator<R, ?> resourceDiscriminator, Boolean useSSA, OnAddFilter<R> onAddFilter, OnUpdateFilter<R> onUpdateFilter, OnDeleteFilter<R> onDeleteFilter, GenericFilter<R> genericFilter) {
        this.namespaces = namespaces;
        this.labelSelector = labelSelector;
        this.namespacesWereConfigured = configuredNS;
        this.createResourceOnlyIfNotExistingWithSSA = createResourceOnlyIfNotExistingWithSSA;
        this.onAddFilter = onAddFilter;
        this.onUpdateFilter = onUpdateFilter;
        this.onDeleteFilter = onDeleteFilter;
        this.genericFilter = genericFilter;
        this.resourceDiscriminator = resourceDiscriminator;
        this.useSSA = useSSA;
    }

    @Deprecated(forRemoval=true)
    public KubernetesDependentResourceConfig(Set<String> namespaces, String labelSelector) {
        this(namespaces, labelSelector, true, true, null, null, null, null, null, null);
    }

    @Deprecated(forRemoval=true)
    public KubernetesDependentResourceConfig<R> setLabelSelector(String labelSelector) {
        this.labelSelector = labelSelector;
        return this;
    }

    public Set<String> namespaces() {
        return this.namespaces;
    }

    public String labelSelector() {
        return this.labelSelector;
    }

    public boolean wereNamespacesConfigured() {
        return this.namespacesWereConfigured;
    }

    public OnAddFilter onAddFilter() {
        return this.onAddFilter;
    }

    public boolean createResourceOnlyIfNotExistingWithSSA() {
        return this.createResourceOnlyIfNotExistingWithSSA;
    }

    public OnUpdateFilter<R> onUpdateFilter() {
        return this.onUpdateFilter;
    }

    public OnDeleteFilter<R> onDeleteFilter() {
        return this.onDeleteFilter;
    }

    public GenericFilter<R> genericFilter() {
        return this.genericFilter;
    }

    public ResourceDiscriminator getResourceDiscriminator() {
        return this.resourceDiscriminator;
    }

    protected void setNamespaces(Set<String> namespaces) {
        if (!this.wereNamespacesConfigured() && namespaces != null && !namespaces.isEmpty()) {
            this.namespaces = namespaces;
        }
    }

    public Optional<Boolean> useSSA() {
        return Optional.ofNullable(this.useSSA);
    }
}

