/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator;

import io.javaoperatorsdk.operator.OperatorException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class AggregatedOperatorException
extends OperatorException {
    private final Map<String, Exception> causes;

    public AggregatedOperatorException(String message, Map<String, Exception> exceptions) {
        super(message);
        this.causes = exceptions != null ? Collections.unmodifiableMap(exceptions) : Collections.emptyMap();
    }

    public Map<String, Exception> getAggregatedExceptions() {
        return this.causes;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + " " + this.causes.entrySet().stream().map(entry -> (String)entry.getKey() + " -> " + AggregatedOperatorException.exceptionDescription(entry)).collect(Collectors.joining("\n - ", "Details:\n - ", ""));
    }

    private static String exceptionDescription(Map.Entry<String, Exception> entry) {
        Exception exception = entry.getValue();
        StringWriter out = new StringWriter(2000);
        PrintWriter stringWriter = new PrintWriter(out);
        exception.printStackTrace(stringWriter);
        return out.toString();
    }
}

