/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core.dependent;

import io.debezium.operator.api.model.CommonLabels;
import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.api.model.DebeziumServerSpec;
import io.debezium.operator.api.model.Quarkus;
import io.debezium.operator.api.model.runtime.Runtime;
import io.debezium.operator.api.model.runtime.RuntimeEnvironment;
import io.debezium.operator.api.model.runtime.jmx.JmxAuthentication;
import io.debezium.operator.api.model.runtime.jmx.JmxConfig;
import io.debezium.operator.api.model.runtime.metrics.JmxExporter;
import io.debezium.operator.api.model.runtime.metrics.Metrics;
import io.debezium.operator.api.model.runtime.storage.DataStorage;
import io.debezium.operator.api.model.runtime.storage.RuntimeStorage;
import io.debezium.operator.api.model.runtime.templates.ContainerTemplate;
import io.debezium.operator.api.model.runtime.templates.MetadataTemplate;
import io.debezium.operator.api.model.runtime.templates.PodTemplate;
import io.debezium.operator.api.model.runtime.templates.Probe;
import io.debezium.operator.api.model.runtime.templates.Templates;
import io.debezium.operator.commons.util.StringUtils;
import io.debezium.operator.core.VersionProvider;
import io.debezium.operator.core.dependent.PvcDependent;
import io.debezium.operator.core.dependent.ServiceAccountDependent;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.EmptyDirVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.HTTPGetActionBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecBuilder;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;

public class DeploymentDependent
extends CRUDKubernetesDependentResource<Deployment, DebeziumServer> {
    public static final String DEFAULT_IMAGE = "quay.io/debezium/server";
    public static final String CONFIG_VOLUME_NAME = "ds-config";
    public static final String CONFIG_FILE_NAME = "application.properties";
    public static final String CONFIG_DIR_PATH = "/debezium/conf";
    public static final String CONFIG_FILE_PATH = "/debezium/conf/application.properties";
    public static final String METRICS_VOLUME_NAME = "ds-metrics";
    public static final String METRICS_DIR_PATH = "/debezium/metrics";
    public static final String METRICS_FILE_PATH = "/debezium/metrics/%s";
    public static final String DATA_VOLUME_NAME = "ds-data";
    public static final String DATA_VOLUME_PATH = "/debezium/data";
    public static final String JMX_CONFIG_VOLUME_NAME = "ds-jmx-config";
    public static final String JMX_CONFIG_VOLUME_INIT_NAME = "ds-jmx-config-init";
    public static final String JMX_CONFIG_VOLUME_PATH = "/debezium/conf/jmx";
    public static final String JMX_CONFIG_VOLUME_INIT_PATH = "/jmx";
    public static final String EXTERNAL_VOLUME_PATH = "/debezium/external/%s";
    public static final int DEFAULT_HTTP_PORT = 8080;
    public static final int DEFAULT_JMX_EXPORTER_METRICS_PORT = 9090;
    public static final String JMX_EXPORTER_METRICS_PORT_NAME = "metrics-jmx";
    private static final String CONFIG_MD5_ANNOTATION = "debezium.io/server-config-md5";
    @ConfigProperty(name="debezium.image", defaultValue="quay.io/debezium/server")
    String defaultImage;
    @Inject
    VersionProvider version;

    public DeploymentDependent() {
        super(Deployment.class);
    }

    protected Deployment desired(DebeziumServer primary, Context<DebeziumServer> context) {
        Runtime runtime = ((DebeziumServerSpec)primary.getSpec()).getRuntime();
        RuntimeStorage storage = runtime.getStorage();
        Templates templates = runtime.getTemplates();
        String name = primary.getMetadata().getName();
        Map labels = CommonLabels.serverComponent((String)name).getMap();
        Map<String, String> annotations = Map.of(CONFIG_MD5_ANNOTATION, primary.asConfiguration().md5Sum());
        String sa = ServiceAccountDependent.serviceAccountNameFor(primary);
        Container desiredContainer = this.desiredServerContainer(primary);
        PodTemplateSpec pod = ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withLabels(labels)).withAnnotations(annotations)).build())).withSpec(((PodSpecBuilder)((PodSpecBuilder)((PodSpecBuilder)new PodSpecBuilder().withServiceAccountName(sa)).addToVolumes(new Volume[]{((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(CONFIG_VOLUME_NAME)).withConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(name)).build())).build()})).addToContainers(new Container[]{desiredContainer})).build())).build();
        this.addTemplateConfigurationToPod(templates.getPod(), pod);
        this.addStorageVolumesToPod(primary, storage, pod);
        this.addJmxConfigurationToPod(primary, pod);
        this.addMetricConfigurationToPod(primary, pod);
        return ((DeploymentBuilder)((DeploymentBuilder)new DeploymentBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(primary.getMetadata().getNamespace())).withName(name)).withLabels(labels)).withAnnotations(annotations)).build())).withSpec(((DeploymentSpecBuilder)((DeploymentSpecBuilder)new DeploymentSpecBuilder().withSelector(((LabelSelectorBuilder)new LabelSelectorBuilder().addToMatchLabels(labels)).build())).withTemplate(pod)).build())).build();
    }

    private void addMetricConfigurationToPod(DebeziumServer primary, PodTemplateSpec pod) {
        Metrics metrics = ((DebeziumServerSpec)primary.getSpec()).getRuntime().getMetrics();
        JmxExporter jmxExporter = metrics.getJmxExporter();
        List volumes = pod.getSpec().getVolumes();
        if (!jmxExporter.isEnabled()) {
            return;
        }
        ConfigMapKeySelector configMapRef = jmxExporter.getConfigFrom();
        if (configMapRef == null) {
            return;
        }
        Volume metricsVolume = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(METRICS_VOLUME_NAME)).withConfigMap(((ConfigMapVolumeSourceBuilder)new ConfigMapVolumeSourceBuilder().withName(configMapRef.getName())).build())).build();
        volumes.add(metricsVolume);
    }

    private void addTemplateConfigurationToPod(PodTemplate template, PodTemplateSpec pod) {
        MetadataTemplate templateMeta = template.getMetadata();
        PodSpec podSpec = pod.getSpec();
        ObjectMeta podMeta = pod.getMetadata();
        podSpec.setSecurityContext(template.getSecurityContext());
        podSpec.setAffinity(template.getAffinity());
        podSpec.setImagePullSecrets(template.getImagePullSecrets());
        podMeta.getLabels().putAll(templateMeta.getLabels());
        podMeta.getAnnotations().putAll(templateMeta.getAnnotations());
    }

    private void addStorageVolumesToPod(DebeziumServer primary, RuntimeStorage storage, PodTemplateSpec pod) {
        List volumes = pod.getSpec().getVolumes();
        this.desiredDataVolume(primary).ifPresent(volumes::add);
        volumes.addAll(storage.getExternal());
    }

    private Optional<Volume> desiredDataVolume(DebeziumServer primary) {
        VolumeBuilder builder = (VolumeBuilder)new VolumeBuilder().withName(DATA_VOLUME_NAME);
        DataStorage dataStorage = ((DebeziumServerSpec)primary.getSpec()).getRuntime().getStorage().getData();
        switch (dataStorage.getType()) {
            case EPHEMERAL: {
                builder.withEmptyDir(new EmptyDirVolumeSourceBuilder().build());
                break;
            }
            case PERSISTENT: {
                builder.withPersistentVolumeClaim(((PersistentVolumeClaimVolumeSourceBuilder)new PersistentVolumeClaimVolumeSourceBuilder().withClaimName(PvcDependent.pvcNameFor(primary))).build());
            }
        }
        Volume volume = builder.build();
        return Optional.of(volume);
    }

    private Optional<VolumeMount> desiredDataVolumeMount() {
        VolumeMount volumeMount = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(DATA_VOLUME_NAME)).withMountPath(DATA_VOLUME_PATH)).build();
        return Optional.of(volumeMount);
    }

    private void addJmxConfigurationToPod(DebeziumServer primary, PodTemplateSpec pod) {
        JmxConfig jmx = ((DebeziumServerSpec)primary.getSpec()).getRuntime().getJmx();
        JmxAuthentication auth = jmx.getAuthentication();
        if (!auth.isEnabled()) {
            return;
        }
        List volumes = pod.getSpec().getVolumes();
        List initContainers = pod.getSpec().getInitContainers();
        Volume jmxInitVolume = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(JMX_CONFIG_VOLUME_INIT_NAME)).withSecret(((SecretVolumeSourceBuilder)new SecretVolumeSourceBuilder().withSecretName(auth.getSecret())).build())).build();
        Volume jmxConfigVolume = ((VolumeBuilder)((VolumeBuilder)new VolumeBuilder().withName(JMX_CONFIG_VOLUME_NAME)).withEmptyDir(new EmptyDirVolumeSourceBuilder().build())).build();
        volumes.add(jmxInitVolume);
        volumes.add(jmxConfigVolume);
        String image = this.getTaggedImage(primary);
        Optional<Container> container = this.desiredJmxInitContainer(jmx, image);
        container.ifPresent(initContainers::add);
    }

    private void addTemplateConfigurationToContainer(ContainerTemplate template, Container container) {
        container.setSecurityContext(template.getSecurityContext());
        container.setResources(template.getResources());
    }

    private Container desiredServerContainer(DebeziumServer primary) {
        Quarkus quarkus = ((DebeziumServerSpec)primary.getSpec()).getQuarkus();
        Runtime runtime = ((DebeziumServerSpec)primary.getSpec()).getRuntime();
        ContainerTemplate template = runtime.getTemplates().getContainer();
        RuntimeStorage storage = runtime.getStorage();
        RuntimeEnvironment environment = runtime.getEnvironment();
        JmxConfig jmx = runtime.getJmx();
        Metrics metrics = runtime.getMetrics();
        Integer probePort = quarkus.getConfig().getProps().getOrDefault("http.port", 8080);
        Probe livenessProbe = template.getProbes().getLiveness();
        Probe readinessProbe = template.getProbes().getReadiness();
        String image = this.getTaggedImage(primary);
        Container container = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("server")).withImage(image)).withLivenessProbe(((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withFailureThreshold(Integer.valueOf(livenessProbe.getFailureThreshold()))).withInitialDelaySeconds(Integer.valueOf(livenessProbe.getInitialDelaySeconds()))).withTimeoutSeconds(Integer.valueOf(livenessProbe.getTimeoutSeconds()))).withPeriodSeconds(Integer.valueOf(livenessProbe.getPeriodSeconds()))).withHttpGet(((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath("/q/health/live")).withPort(new IntOrString((Object)probePort))).build())).build())).withReadinessProbe(((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withFailureThreshold(Integer.valueOf(readinessProbe.getFailureThreshold()))).withInitialDelaySeconds(Integer.valueOf(readinessProbe.getInitialDelaySeconds()))).withTimeoutSeconds(Integer.valueOf(readinessProbe.getTimeoutSeconds()))).withPeriodSeconds(Integer.valueOf(readinessProbe.getPeriodSeconds()))).withHttpGet(((HTTPGetActionBuilder)((HTTPGetActionBuilder)new HTTPGetActionBuilder().withPath("/q/health/ready")).withPort(new IntOrString((Object)probePort))).build())).build())).withPorts(new ContainerPort[]{((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("http")).withProtocol("TCP")).withContainerPort(Integer.valueOf(8080))).build()})).addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(CONFIG_VOLUME_NAME)).withMountPath(CONFIG_FILE_PATH)).withSubPath(CONFIG_FILE_NAME)).build()})).build();
        this.addTemplateConfigurationToContainer(template, container);
        this.addEnvVariablesToContainer(environment, container);
        this.addStorageVolumeMountsToContainer(storage, container);
        this.addJmxConfigurationToContainer(jmx, container);
        this.addMetricConfigurationToContainer(metrics, container);
        return container;
    }

    private void addMetricConfigurationToContainer(Metrics metrics, Container container) {
        JmxExporter jmxExporter = metrics.getJmxExporter();
        if (!jmxExporter.isEnabled()) {
            return;
        }
        EnvVar portEnv = new EnvVar("JMX_EXPORTER_PORT", String.valueOf(9090), null);
        ContainerPort port = ((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(JMX_EXPORTER_METRICS_PORT_NAME)).withProtocol("TCP")).withContainerPort(Integer.valueOf(9090))).build();
        container.getEnv().add(portEnv);
        container.getPorts().add(port);
        ConfigMapKeySelector configMapRef = metrics.getJmxExporter().getConfigFrom();
        if (configMapRef == null) {
            return;
        }
        String configFile = METRICS_FILE_PATH.formatted(configMapRef.getKey());
        EnvVar configEnv = new EnvVar("JMX_EXPORTER_CONFIG", configFile, null);
        VolumeMount mount = ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(METRICS_VOLUME_NAME)).withMountPath(METRICS_DIR_PATH)).build();
        container.getEnv().add(configEnv);
        container.getVolumeMounts().add(mount);
    }

    private Optional<Container> desiredJmxInitContainer(JmxConfig jmx, String image) {
        JmxAuthentication auth = jmx.getAuthentication();
        if (!auth.isEnabled()) {
            return Optional.empty();
        }
        Container initContainer = ((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)((ContainerBuilder)new ContainerBuilder().withName("server-init")).withImage(image)).withCommand(new String[]{"sh", "-c", JmxCmd.of(auth.getAccessFile()) + " && " + JmxCmd.of(auth.getPasswordFile())})).addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(JMX_CONFIG_VOLUME_INIT_NAME)).withMountPath(JMX_CONFIG_VOLUME_INIT_PATH)).build()})).addToVolumeMounts(new VolumeMount[]{((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(JMX_CONFIG_VOLUME_NAME)).withMountPath(JMX_CONFIG_VOLUME_PATH)).build()})).build();
        return Optional.of(initContainer);
    }

    private void addStorageVolumeMountsToContainer(RuntimeStorage storage, Container container) {
        List volumeMounts = container.getVolumeMounts();
        this.desiredDataVolumeMount().ifPresent(volumeMounts::add);
        storage.getExternal().stream().map(volume -> ((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(volume.getName())).withMountPath(EXTERNAL_VOLUME_PATH.formatted(volume.getName()))).build()).forEach(volumeMounts::add);
    }

    private void addEnvVariablesToContainer(RuntimeEnvironment environment, Container container) {
        List<EnvVar> variables = environment.getVars().stream().map(ce -> new EnvVar(ce.getName(), ce.getValue(), null)).toList();
        container.getEnv().addAll(variables);
        container.getEnvFrom().addAll(environment.getFrom());
    }

    private void addJmxConfigurationToContainer(JmxConfig jmx, Container container) {
        if (!jmx.isEnabled()) {
            return;
        }
        List ports = container.getPorts();
        ports.add(((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName("jmx")).withProtocol("TCP")).withContainerPort(Integer.valueOf(jmx.getPort()))).build());
        HashMap<String, Boolean> opts = new HashMap<String, Boolean>(Map.of("-Dcom.sun.management.jmxremote.ssl", false, "-Dcom.sun.management.jmxremote.port", jmx.getPort(), "-Dcom.sun.management.jmxremote.rmi.port", jmx.getPort(), "-Dcom.sun.management.jmxremote.local.only", false, "-Djava.rmi.server.hostname", "0.0.0.0", "-Dcom.sun.management.jmxremote.verbose", true, "-Dcom.sun.management.jmxremote.authenticate", false));
        JmxAuthentication auth = jmx.getAuthentication();
        if (auth.isEnabled()) {
            opts.putAll(Map.of("-Dcom.sun.management.jmxremote.authenticate", true, "-Dcom.sun.management.jmxremote.access.file", "/debezium/conf/jmx/" + auth.getAccessFile(), "-Dcom.sun.management.jmxremote.password.file", "/debezium/conf/jmx/" + auth.getPasswordFile()));
            VolumeMount mount = ((VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withName(JMX_CONFIG_VOLUME_NAME)).withMountPath(JMX_CONFIG_VOLUME_PATH)).withReadOnly(Boolean.valueOf(true))).build();
            container.getVolumeMounts().add(mount);
        }
        this.mergeJavaOptsEnvVar(opts, container);
    }

    private void mergeJavaOptsEnvVar(Map<String, ?> newValue, Container container) {
        String name = "JAVA_OPTS";
        List env = container.getEnv();
        Optional<EnvVar> currentEnvVar = env.stream().filter(envVar -> "JAVA_OPTS".equals(envVar.getName())).findFirst();
        currentEnvVar.ifPresent(env::remove);
        Map currentProperties = currentEnvVar.map(EnvVar::getValue).map(StringUtils::splitJavaOpts).orElse(Map.of());
        Map<String, Object> additionalProperties = newValue.keySet().stream().filter(Predicate.not(currentProperties::containsKey)).collect(Collectors.toMap(k -> k, newValue::get));
        HashMap mergedProperties = new HashMap();
        mergedProperties.putAll(currentProperties);
        mergedProperties.putAll(additionalProperties);
        env.add(new EnvVar("JAVA_OPTS", StringUtils.joinAsJavaOpts(mergedProperties), null));
    }

    private String getTaggedImage(DebeziumServer primary) {
        Object image = ((DebeziumServerSpec)primary.getSpec()).getImage();
        if (image == null) {
            image = this.defaultImage + ":" + this.version.getImageTag(primary);
        }
        return image;
    }

    private static final class JmxCmd {
        private final String source;
        private final String target;

        private JmxCmd(String file) {
            this.source = "/jmx/" + file;
            this.target = "/debezium/conf/jmx/" + file;
        }

        public String toString() {
            return "cp '%s' '%s' && chmod 600 '%s'".formatted(this.source, this.target, this.target);
        }

        public static JmxCmd of(String file) {
            return new JmxCmd(file);
        }
    }
}

