/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.crd.generator.v1beta1.decorator;

import io.fabric8.crd.generator.decorator.Decorator;
import io.fabric8.crd.generator.v1beta1.decorator.CustomResourceDefinitionDecorator;
import io.fabric8.crd.generator.v1beta1.decorator.CustomResourceDefinitionVersionDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionSpecFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class EnsureSingleStorageVersionDecorator
extends CustomResourceDefinitionDecorator<CustomResourceDefinitionSpecFluent<?>> {
    public EnsureSingleStorageVersionDecorator(String name) {
        super(name);
    }

    @Override
    public void andThenVisit(CustomResourceDefinitionSpecFluent<?> spec, ObjectMeta resourceMeta) {
        List versions = spec.buildVersions();
        List storageVersions = versions.stream().filter(v -> Optional.ofNullable(v.getStorage()).orElse(true)).map(CustomResourceDefinitionVersion::getName).collect(Collectors.toList());
        if (storageVersions.size() > 1) {
            throw new IllegalStateException(String.format("'%s' custom resource has versions %s marked as storage. Only one version can be marked as storage per custom resource.", resourceMeta.getName(), storageVersions));
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{CustomResourceDefinitionVersionDecorator.class};
    }

    public String toString() {
        return this.getClass().getName() + " [name:" + this.getName() + "]";
    }
}

