/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.api.model.runtime.jmx;

import io.debezium.operator.api.model.runtime.jmx.JmxAuthentication;
import io.debezium.operator.api.model.runtime.jmx.JmxAuthenticationBuilder;
import io.debezium.operator.api.model.runtime.jmx.JmxAuthenticationFluent;
import io.debezium.operator.api.model.runtime.jmx.JmxConfig;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class JmxConfigFluent<A extends JmxConfigFluent<A>>
extends BaseFluent<A> {
    private boolean enabled;
    private int port;
    private JmxAuthenticationBuilder authentication;

    public JmxConfigFluent() {
    }

    public JmxConfigFluent(JmxConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JmxConfig instance) {
        JmxConfig jmxConfig = instance = instance != null ? instance : new JmxConfig();
        if (instance != null) {
            this.withEnabled(instance.isEnabled());
            this.withPort(instance.getPort());
            this.withAuthentication(instance.getAuthentication());
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public A withEnabled(boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return true;
    }

    public int getPort() {
        return this.port;
    }

    public A withPort(int port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return true;
    }

    public JmxAuthentication buildAuthentication() {
        return this.authentication != null ? this.authentication.build() : null;
    }

    public A withAuthentication(JmxAuthentication authentication) {
        this._visitables.remove((Object)"authentication");
        if (authentication != null) {
            this.authentication = new JmxAuthenticationBuilder(authentication);
            this._visitables.get((Object)"authentication").add(this.authentication);
        } else {
            this.authentication = null;
            this._visitables.get((Object)"authentication").remove((Object)this.authentication);
        }
        return (A)((Object)this);
    }

    public boolean hasAuthentication() {
        return this.authentication != null;
    }

    public AuthenticationNested<A> withNewAuthentication() {
        return new AuthenticationNested(null);
    }

    public AuthenticationNested<A> withNewAuthenticationLike(JmxAuthentication item) {
        return new AuthenticationNested(item);
    }

    public AuthenticationNested<A> editAuthentication() {
        return this.withNewAuthenticationLike(Optional.ofNullable(this.buildAuthentication()).orElse(null));
    }

    public AuthenticationNested<A> editOrNewAuthentication() {
        return this.withNewAuthenticationLike(Optional.ofNullable(this.buildAuthentication()).orElse(new JmxAuthenticationBuilder().build()));
    }

    public AuthenticationNested<A> editOrNewAuthenticationLike(JmxAuthentication item) {
        return this.withNewAuthenticationLike(Optional.ofNullable(this.buildAuthentication()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JmxConfigFluent that = (JmxConfigFluent)((Object)o);
        if (this.enabled != that.enabled) {
            return false;
        }
        if (this.port != that.port) {
            return false;
        }
        return Objects.equals((Object)this.authentication, (Object)that.authentication);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.port, this.authentication, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("enabled:");
        sb.append(this.enabled + ",");
        sb.append("port:");
        sb.append(this.port + ",");
        if (this.authentication != null) {
            sb.append("authentication:");
            sb.append((Object)this.authentication);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class AuthenticationNested<N>
    extends JmxAuthenticationFluent<AuthenticationNested<N>>
    implements Nested<N> {
        JmxAuthenticationBuilder builder;

        AuthenticationNested(JmxAuthentication item) {
            this.builder = new JmxAuthenticationBuilder(this, item);
        }

        public N and() {
            return (N)JmxConfigFluent.this.withAuthentication(this.builder.build());
        }

        public N endAuthentication() {
            return this.and();
        }
    }
}

