/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.Rule;
import io.fabric8.openshift.api.model.monitoring.v1.RuleBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.RuleFluent;
import io.fabric8.openshift.api.model.monitoring.v1.RuleGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RuleGroupFluent<A extends RuleGroupFluent<A>>
extends BaseFluent<A> {
    private String interval;
    private Integer limit;
    private String name;
    private String partialResponseStrategy;
    private ArrayList<RuleBuilder> rules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RuleGroupFluent() {
    }

    public RuleGroupFluent(RuleGroup instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RuleGroup instance) {
        RuleGroup ruleGroup = instance = instance != null ? instance : new RuleGroup();
        if (instance != null) {
            this.withInterval(instance.getInterval());
            this.withLimit(instance.getLimit());
            this.withName(instance.getName());
            this.withPartialResponseStrategy(instance.getPartialResponseStrategy());
            this.withRules(instance.getRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getInterval() {
        return this.interval;
    }

    public A withInterval(String interval) {
        this.interval = interval;
        return (A)((Object)this);
    }

    public boolean hasInterval() {
        return this.interval != null;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public A withLimit(Integer limit) {
        this.limit = limit;
        return (A)((Object)this);
    }

    public boolean hasLimit() {
        return this.limit != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getPartialResponseStrategy() {
        return this.partialResponseStrategy;
    }

    public A withPartialResponseStrategy(String partialResponseStrategy) {
        this.partialResponseStrategy = partialResponseStrategy;
        return (A)((Object)this);
    }

    public boolean hasPartialResponseStrategy() {
        return this.partialResponseStrategy != null;
    }

    public A addToRules(int index, Rule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        RuleBuilder builder = new RuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToRules(int index, Rule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        RuleBuilder builder = new RuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToRules(Rule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToRules(Collection<Rule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromRules(Rule ... items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromRules(Collection<Rule> items) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        for (Rule item : items) {
            RuleBuilder builder = new RuleBuilder(item);
            this._visitables.get((Object)"rules").remove((Object)builder);
            this.rules.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromRules(Predicate<RuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)((Object)this);
        }
        Iterator<RuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            RuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Rule> buildRules() {
        return this.rules != null ? RuleGroupFluent.build(this.rules) : null;
    }

    public Rule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public Rule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public Rule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public Rule buildMatchingRule(Predicate<RuleBuilder> predicate) {
        for (RuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<RuleBuilder> predicate) {
        for (RuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<Rule> rules) {
        if (this.rules != null) {
            this._visitables.get((Object)"rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (Rule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)((Object)this);
    }

    public A withRules(Rule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove((Object)"rules");
        }
        if (rules != null) {
            for (Rule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(Rule item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, Rule item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<RuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleGroupFluent that = (RuleGroupFluent)((Object)o);
        if (!Objects.equals(this.interval, that.interval)) {
            return false;
        }
        if (!Objects.equals(this.limit, that.limit)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.partialResponseStrategy, that.partialResponseStrategy)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.limit, this.name, this.partialResponseStrategy, this.rules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.interval != null) {
            sb.append("interval:");
            sb.append(this.interval + ",");
        }
        if (this.limit != null) {
            sb.append("limit:");
            sb.append(this.limit + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.partialResponseStrategy != null) {
            sb.append("partialResponseStrategy:");
            sb.append(this.partialResponseStrategy + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RulesNested<N>
    extends RuleFluent<RulesNested<N>>
    implements Nested<N> {
        RuleBuilder builder;
        int index;

        RulesNested(int index, Rule item) {
            this.index = index;
            this.builder = new RuleBuilder(this, item);
        }

        public N and() {
            return (N)RuleGroupFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }
}

