/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.polling;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.health.Status;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.CacheKeyMapper;
import io.javaoperatorsdk.operator.processing.event.source.ExternalResourceCachingEventSource;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingEventSource<R, P extends HasMetadata>
extends ExternalResourceCachingEventSource<R, P> {
    private static final Logger log = LoggerFactory.getLogger(PollingEventSource.class);
    private final Timer timer = new Timer();
    private final GenericResourceFetcher<R> genericResourceFetcher;
    private final long period;
    private final AtomicBoolean healthy = new AtomicBoolean(true);

    public PollingEventSource(GenericResourceFetcher<R> supplier, long period, Class<R> resourceClass) {
        super(resourceClass, CacheKeyMapper.singleResourceCacheKeyMapper());
        this.genericResourceFetcher = supplier;
        this.period = period;
    }

    public PollingEventSource(GenericResourceFetcher<R> supplier, long period, Class<R> resourceClass, CacheKeyMapper<R> cacheKeyMapper) {
        super(resourceClass, cacheKeyMapper);
        this.genericResourceFetcher = supplier;
        this.period = period;
    }

    @Override
    public void start() throws OperatorException {
        super.start();
        this.getStateAndFillCache();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (!PollingEventSource.this.isRunning()) {
                        log.debug("Event source not yet started. Will not run.");
                        return;
                    }
                    PollingEventSource.this.getStateAndFillCache();
                    PollingEventSource.this.healthy.set(true);
                }
                catch (RuntimeException e) {
                    PollingEventSource.this.healthy.set(false);
                    log.error("Error during polling.", (Throwable)e);
                }
            }
        }, this.period, this.period);
    }

    protected synchronized void getStateAndFillCache() {
        Map<ResourceID, Set<R>> values = this.genericResourceFetcher.fetchResources();
        this.handleResources(values);
    }

    @Override
    public void stop() throws OperatorException {
        super.stop();
        this.timer.cancel();
    }

    @Override
    public Status getStatus() {
        return this.healthy.get() ? Status.HEALTHY : Status.UNHEALTHY;
    }

    public static interface GenericResourceFetcher<R> {
        public Map<ResourceID, Set<R>> fetchResources();
    }
}

