/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event.source.informer;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.informer.ManagedInformerEventSource;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryResourceCache<T extends HasMetadata> {
    private static final Logger log = LoggerFactory.getLogger(TemporaryResourceCache.class);
    private final Map<ResourceID, T> cache = new ConcurrentHashMap<ResourceID, T>();
    private final ExpirationCache<String> tombstones = new ExpirationCache(1000000, 1200000);
    private final ManagedInformerEventSource<T, ?, ?> managedInformerEventSource;
    private final boolean parseResourceVersions;
    private final ExpirationCache<String> knownResourceVersions;

    public TemporaryResourceCache(ManagedInformerEventSource<T, ?, ?> managedInformerEventSource, boolean parseResourceVersions) {
        this.managedInformerEventSource = managedInformerEventSource;
        this.parseResourceVersions = parseResourceVersions;
        this.knownResourceVersions = parseResourceVersions ? new ExpirationCache(50000, 600000) : null;
    }

    public synchronized void onDeleteEvent(T resource, boolean unknownState) {
        this.tombstones.add(resource.getMetadata().getUid());
        this.onEvent(resource, unknownState);
    }

    public synchronized void onAddOrUpdateEvent(T resource) {
        this.onEvent(resource, false);
    }

    synchronized void onEvent(T resource, boolean unknownState) {
        this.cache.computeIfPresent(ResourceID.fromResource(resource), (id, cached) -> unknownState || !this.isLaterResourceVersion((ResourceID)id, (T)cached, resource) ? null : cached);
    }

    public synchronized void putAddedResource(T newResource) {
        this.putResource(newResource, null);
    }

    public synchronized void putResource(T newResource, String previousResourceVersion) {
        if (this.knownResourceVersions != null) {
            this.knownResourceVersions.add(newResource.getMetadata().getResourceVersion());
        }
        ResourceID resourceId = ResourceID.fromResource(newResource);
        HasMetadata cachedResource = this.getResourceFromCache(resourceId).orElse(this.managedInformerEventSource.get(resourceId).orElse(null));
        boolean moveAhead = false;
        if (previousResourceVersion == null && cachedResource == null) {
            if (this.tombstones.contains(newResource.getMetadata().getUid())) {
                log.debug("Won't resurrect uid {} for resource id: {}", (Object)newResource.getMetadata().getUid(), (Object)resourceId);
                return;
            }
            moveAhead = true;
        }
        if (moveAhead || cachedResource != null && cachedResource.getMetadata().getResourceVersion().equals(previousResourceVersion) || this.isLaterResourceVersion(resourceId, newResource, cachedResource)) {
            log.debug("Temporarily moving ahead to target version {} for resource id: {}", (Object)newResource.getMetadata().getResourceVersion(), (Object)resourceId);
            this.cache.put(resourceId, newResource);
        } else if (this.cache.remove(resourceId) != null) {
            log.debug("Removed an obsolete resource from cache for id: {}", (Object)resourceId);
        }
    }

    public synchronized boolean isKnownResourceVersion(T resource) {
        return this.knownResourceVersions != null && this.knownResourceVersions.contains(resource.getMetadata().getResourceVersion());
    }

    private boolean isLaterResourceVersion(ResourceID resourceId, T newResource, T cachedResource) {
        try {
            if (this.parseResourceVersions && Long.parseLong(newResource.getMetadata().getResourceVersion()) > Long.parseLong(cachedResource.getMetadata().getResourceVersion())) {
                return true;
            }
        }
        catch (NumberFormatException e) {
            log.debug("Could not compare resourceVersions {} and {} for {}", new Object[]{newResource.getMetadata().getResourceVersion(), cachedResource.getMetadata().getResourceVersion(), resourceId});
        }
        return false;
    }

    public synchronized Optional<T> getResourceFromCache(ResourceID resourceID) {
        return Optional.ofNullable((HasMetadata)this.cache.get(resourceID));
    }

    static class ExpirationCache<K> {
        private final LinkedHashMap<K, Long> cache;
        private final int ttlMs;

        public ExpirationCache(final int maxEntries, int ttlMs) {
            this.ttlMs = ttlMs;
            this.cache = new LinkedHashMap<K, Long>(){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, Long> eldest) {
                    return this.size() > maxEntries;
                }
            };
        }

        public void add(K key) {
            this.clean();
            this.cache.putIfAbsent(key, System.currentTimeMillis());
        }

        public boolean contains(K key) {
            this.clean();
            return this.cache.get(key) != null;
        }

        void clean() {
            if (!this.cache.isEmpty()) {
                long currentTimeMillis = System.currentTimeMillis();
                Iterator<Map.Entry<K, Long>> iter = this.cache.entrySet().iterator();
                for (int i = 0; i < 10 && iter.hasNext(); ++i) {
                    Map.Entry<K, Long> entry = iter.next();
                    if (currentTimeMillis - entry.getValue() <= (long)this.ttlMs) continue;
                    iter.remove();
                }
            }
        }
    }
}

