/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.rate.RateLimiter;
import io.javaoperatorsdk.operator.processing.retry.RetryExecution;

class ResourceState {
    private final ResourceID id;
    private boolean underProcessing;
    private RetryExecution retry;
    private EventingState eventing;
    private RateLimiter.RateLimitState rateLimit;

    public ResourceState(ResourceID id) {
        this.id = id;
        this.eventing = EventingState.NO_EVENT_PRESENT;
    }

    public ResourceID getId() {
        return this.id;
    }

    public RateLimiter.RateLimitState getRateLimit() {
        return this.rateLimit;
    }

    public void setRateLimit(RateLimiter.RateLimitState rateLimit) {
        this.rateLimit = rateLimit;
    }

    public RetryExecution getRetry() {
        return this.retry;
    }

    public void setRetry(RetryExecution retry) {
        this.retry = retry;
    }

    public boolean isUnderProcessing() {
        return this.underProcessing;
    }

    public void setUnderProcessing(boolean underProcessing) {
        this.underProcessing = underProcessing;
    }

    public void markDeleteEventReceived() {
        this.eventing = EventingState.DELETE_EVENT_PRESENT;
    }

    public boolean deleteEventPresent() {
        return this.eventing == EventingState.DELETE_EVENT_PRESENT;
    }

    public boolean processedMarkForDeletionPresent() {
        return this.eventing == EventingState.PROCESSED_MARK_FOR_DELETION;
    }

    public void markEventReceived() {
        if (this.deleteEventPresent()) {
            throw new IllegalStateException("Cannot receive event after a delete event received");
        }
        this.eventing = EventingState.EVENT_PRESENT;
    }

    public void markProcessedMarkForDeletion() {
        this.eventing = EventingState.PROCESSED_MARK_FOR_DELETION;
    }

    public boolean eventPresent() {
        return this.eventing == EventingState.EVENT_PRESENT;
    }

    public boolean noEventPresent() {
        return this.eventing == EventingState.NO_EVENT_PRESENT;
    }

    public void unMarkEventReceived() {
        switch (this.eventing) {
            case EVENT_PRESENT: {
                this.eventing = EventingState.NO_EVENT_PRESENT;
                break;
            }
            case PROCESSED_MARK_FOR_DELETION: {
                throw new IllegalStateException("Cannot unmark processed marked for deletion.");
            }
            case DELETE_EVENT_PRESENT: {
                throw new IllegalStateException("Cannot unmark delete event.");
            }
        }
    }

    public String toString() {
        return "ResourceState{id=" + this.id + ", underProcessing=" + this.underProcessing + ", retry=" + this.retry + ", eventing=" + this.eventing + ", rateLimit=" + this.rateLimit + "}";
    }

    private static enum EventingState {
        EVENT_PRESENT,
        NO_EVENT_PRESENT,
        PROCESSED_MARK_FOR_DELETION,
        DELETE_EVENT_PRESENT;

    }
}

