/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.event;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Optional;

final class PostExecutionControl<R extends HasMetadata> {
    private final boolean finalizerRemoved;
    private final R updatedCustomResource;
    private final boolean updateIsStatusPatch;
    private final Exception runtimeException;
    private Long reScheduleDelay = null;

    private PostExecutionControl(boolean finalizerRemoved, R updatedCustomResource, boolean updateIsStatusPatch, Exception runtimeException) {
        this.finalizerRemoved = finalizerRemoved;
        this.updatedCustomResource = updatedCustomResource;
        this.updateIsStatusPatch = updateIsStatusPatch;
        this.runtimeException = runtimeException;
    }

    public static <R extends HasMetadata> PostExecutionControl<R> onlyFinalizerAdded(R updatedCustomResource) {
        return new PostExecutionControl<R>(false, updatedCustomResource, false, null);
    }

    public static <R extends HasMetadata> PostExecutionControl<R> defaultDispatch() {
        return new PostExecutionControl<Object>(false, null, false, null);
    }

    public static <R extends HasMetadata> PostExecutionControl<R> customResourceStatusPatched(R updatedCustomResource) {
        return new PostExecutionControl<R>(false, updatedCustomResource, true, null);
    }

    public static <R extends HasMetadata> PostExecutionControl<R> customResourceUpdated(R updatedCustomResource) {
        return new PostExecutionControl<R>(false, updatedCustomResource, false, null);
    }

    public static <R extends HasMetadata> PostExecutionControl<R> customResourceFinalizerRemoved(R updatedCustomResource) {
        return new PostExecutionControl<R>(true, updatedCustomResource, false, null);
    }

    public static <R extends HasMetadata> PostExecutionControl<R> exceptionDuringExecution(Exception exception) {
        return new PostExecutionControl<Object>(false, null, false, exception);
    }

    public Optional<R> getUpdatedCustomResource() {
        return Optional.ofNullable(this.updatedCustomResource);
    }

    public boolean exceptionDuringExecution() {
        return this.runtimeException != null;
    }

    public PostExecutionControl<R> withReSchedule(long delay) {
        this.reScheduleDelay = delay;
        return this;
    }

    public Optional<Exception> getRuntimeException() {
        return Optional.ofNullable(this.runtimeException);
    }

    public Optional<Long> getReScheduleDelay() {
        return Optional.ofNullable(this.reScheduleDelay);
    }

    public boolean updateIsStatusPatch() {
        return this.updateIsStatusPatch;
    }

    public String toString() {
        return "PostExecutionControl{onlyFinalizerHandled=" + this.finalizerRemoved + ", updatedCustomResource=" + this.updatedCustomResource + ", runtimeException=" + this.runtimeException + "}";
    }

    public boolean isFinalizerRemoved() {
        return this.finalizerRemoved;
    }
}

