/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing.dependent;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.Ignore;
import io.javaoperatorsdk.operator.api.reconciler.dependent.Deleter;
import io.javaoperatorsdk.operator.api.reconciler.dependent.ReconcileResult;
import io.javaoperatorsdk.operator.processing.dependent.AbstractDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.BulkDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.Creator;
import io.javaoperatorsdk.operator.processing.dependent.DependentResourceReconciler;
import io.javaoperatorsdk.operator.processing.dependent.Matcher;
import io.javaoperatorsdk.operator.processing.dependent.Updater;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class BulkDependentResourceReconciler<R, P extends HasMetadata>
implements DependentResourceReconciler<R, P> {
    private final BulkDependentResource<R, P> bulkDependentResource;

    BulkDependentResourceReconciler(BulkDependentResource<R, P> bulkDependentResource) {
        this.bulkDependentResource = bulkDependentResource;
    }

    @Override
    public ReconcileResult<R> reconcile(P primary, Context<P> context) {
        Map<String, R> desiredResources = this.bulkDependentResource.desiredResources(primary, context);
        Map<String, R> actualResources = this.bulkDependentResource.getSecondaryResources(primary, context);
        this.deleteExtraResources(desiredResources.keySet(), actualResources, primary, context);
        ArrayList results = new ArrayList(desiredResources.size());
        boolean updatable = this.bulkDependentResource instanceof Updater;
        desiredResources.forEach((key, value) -> {
            BulkDependentResourceInstance instance = updatable ? new UpdatableBulkDependentResourceInstance<Object, P>(this.bulkDependentResource, value) : new BulkDependentResourceInstance<Object, P>(this.bulkDependentResource, value);
            results.add(instance.reconcile(primary, actualResources.get(key), context));
        });
        return ReconcileResult.aggregatedResult(results);
    }

    @Override
    public void delete(P primary, Context<P> context) {
        Map<String, R> actualResources = this.bulkDependentResource.getSecondaryResources(primary, context);
        this.deleteExtraResources(Collections.emptySet(), actualResources, primary, context);
    }

    private void deleteExtraResources(Set<String> expectedKeys, Map<String, R> actualResources, P primary, Context<P> context) {
        actualResources.forEach((key, value) -> {
            if (!expectedKeys.contains(key)) {
                this.bulkDependentResource.deleteTargetResource((HasMetadata)primary, value, (String)key, (Context<HasMetadata>)context);
            }
        });
    }

    @Ignore
    private static class UpdatableBulkDependentResourceInstance<R, P extends HasMetadata>
    extends BulkDependentResourceInstance<R, P>
    implements Updater<R, P> {
        private UpdatableBulkDependentResourceInstance(BulkDependentResource<R, P> bulkDependentResource, R desired) {
            super(bulkDependentResource, desired);
        }
    }

    @Ignore
    private static class BulkDependentResourceInstance<R, P extends HasMetadata>
    extends AbstractDependentResource<R, P>
    implements Creator<R, P>,
    Deleter<P> {
        private final BulkDependentResource<R, P> bulkDependentResource;
        private final R desired;

        private BulkDependentResourceInstance(BulkDependentResource<R, P> bulkDependentResource, R desired) {
            this.bulkDependentResource = bulkDependentResource;
            this.desired = desired;
        }

        private AbstractDependentResource<R, P> asAbstractDependentResource() {
            return (AbstractDependentResource)((Object)this.bulkDependentResource);
        }

        @Override
        protected R desired(P primary, Context<P> context) {
            return this.desired;
        }

        public R update(R actual, R desired, P primary, Context<P> context) {
            return ((Updater)((Object)this.bulkDependentResource)).update(actual, desired, primary, context);
        }

        @Override
        public Matcher.Result<R> match(R resource, P primary, Context<P> context) {
            return this.bulkDependentResource.match(resource, this.desired, primary, context);
        }

        @Override
        protected void onCreated(P primary, R created, Context<P> context) {
            this.asAbstractDependentResource().onCreated(primary, created, context);
        }

        @Override
        protected void onUpdated(P primary, R updated, R actual, Context<P> context) {
            this.asAbstractDependentResource().onUpdated(primary, updated, actual, context);
        }

        @Override
        public Class<R> resourceType() {
            return this.asAbstractDependentResource().resourceType();
        }

        @Override
        public R create(R desired, P primary, Context<P> context) {
            return this.bulkDependentResource.create(desired, primary, context);
        }
    }
}

