/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.processing;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinition;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.javaoperatorsdk.operator.CustomResourceUtils;
import io.javaoperatorsdk.operator.MissingCRDException;
import io.javaoperatorsdk.operator.OperatorException;
import io.javaoperatorsdk.operator.RegisteredController;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.ControllerConfiguration;
import io.javaoperatorsdk.operator.api.config.ExecutorServiceManager;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.Cleaner;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.api.reconciler.ContextInitializer;
import io.javaoperatorsdk.operator.api.reconciler.DeleteControl;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceContext;
import io.javaoperatorsdk.operator.api.reconciler.EventSourceInitializer;
import io.javaoperatorsdk.operator.api.reconciler.Ignore;
import io.javaoperatorsdk.operator.api.reconciler.Reconciler;
import io.javaoperatorsdk.operator.api.reconciler.UpdateControl;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResource;
import io.javaoperatorsdk.operator.api.reconciler.dependent.EventSourceNotFoundException;
import io.javaoperatorsdk.operator.api.reconciler.dependent.EventSourceProvider;
import io.javaoperatorsdk.operator.api.reconciler.dependent.EventSourceReferencer;
import io.javaoperatorsdk.operator.api.reconciler.dependent.managed.DefaultManagedDependentResourceContext;
import io.javaoperatorsdk.operator.health.ControllerHealthInfo;
import io.javaoperatorsdk.operator.processing.GroupVersionKind;
import io.javaoperatorsdk.operator.processing.LifecycleAware;
import io.javaoperatorsdk.operator.processing.dependent.workflow.ManagedWorkflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.Workflow;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowCleanupResult;
import io.javaoperatorsdk.operator.processing.dependent.workflow.WorkflowReconcileResult;
import io.javaoperatorsdk.operator.processing.event.EventProcessor;
import io.javaoperatorsdk.operator.processing.event.EventSourceManager;
import io.javaoperatorsdk.operator.processing.event.ResourceID;
import io.javaoperatorsdk.operator.processing.event.source.EventSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class Controller<P extends HasMetadata>
implements Reconciler<P>,
LifecycleAware,
Cleaner<P>,
RegisteredController<P> {
    private static final Logger log = LoggerFactory.getLogger(Controller.class);
    private static final String CLEANUP = "cleanup";
    private static final String DELETE = "delete";
    private static final String FINALIZER_NOT_REMOVED = "finalizerNotRemoved";
    private static final String RECONCILE = "reconcile";
    private static final String RESOURCE = "resource";
    private static final String STATUS = "status";
    private static final String BOTH = "both";
    private final Reconciler<P> reconciler;
    private final ControllerConfiguration<P> configuration;
    private final KubernetesClient kubernetesClient;
    private final EventSourceManager<P> eventSourceManager;
    private final boolean contextInitializer;
    private final boolean isCleaner;
    private final Metrics metrics;
    private final Workflow<P> managedWorkflow;
    private final GroupVersionKind associatedGVK;
    private final EventProcessor<P> eventProcessor;
    private final ControllerHealthInfo controllerHealthInfo;
    private final EventSourceContext<P> eventSourceContext;

    public Controller(Reconciler<P> reconciler, ControllerConfiguration<P> configuration, KubernetesClient kubernetesClient) {
        this.associatedGVK = GroupVersionKind.gvkFor(configuration.getResourceClass());
        ConfigurationService configurationService = configuration.getConfigurationService();
        this.reconciler = reconciler;
        this.configuration = configuration;
        this.kubernetesClient = kubernetesClient;
        this.metrics = Optional.ofNullable(configurationService.getMetrics()).orElse(Metrics.NOOP);
        this.contextInitializer = reconciler instanceof ContextInitializer;
        this.isCleaner = reconciler instanceof Cleaner;
        ManagedWorkflow managed = configurationService.getWorkflowFactory().workflowFor(configuration);
        this.managedWorkflow = managed.resolve(kubernetesClient, configuration);
        this.eventSourceManager = new EventSourceManager(this);
        this.eventProcessor = new EventProcessor<P>(this.eventSourceManager, configurationService);
        this.eventSourceManager.postProcessDefaultEventSourcesAfterProcessorInitializer();
        this.controllerHealthInfo = new ControllerHealthInfo(this.eventSourceManager);
        this.eventSourceContext = new EventSourceContext<P>(this.eventSourceManager.getControllerResourceEventSource(), configuration, kubernetesClient);
        this.initAndRegisterEventSources(this.eventSourceContext);
        configurationService.getMetrics().controllerRegistered(this);
    }

    @Override
    public UpdateControl<P> reconcile(P resource, Context<P> context) throws Exception {
        return (UpdateControl)this.metrics.timeControllerExecution(new Metrics.ControllerExecution<UpdateControl<P>>((HasMetadata)resource, context){
            final /* synthetic */ HasMetadata val$resource;
            final /* synthetic */ Context val$context;
            {
                this.val$resource = hasMetadata;
                this.val$context = context;
            }

            @Override
            public String name() {
                return Controller.RECONCILE;
            }

            @Override
            public String controllerName() {
                return Controller.this.configuration.getName();
            }

            @Override
            public String successTypeName(UpdateControl<P> result) {
                String successType = Controller.RESOURCE;
                if (result.isUpdateStatus()) {
                    successType = Controller.STATUS;
                }
                if (result.isUpdateResourceAndStatus()) {
                    successType = Controller.BOTH;
                }
                return successType;
            }

            @Override
            public ResourceID resourceID() {
                return ResourceID.fromResource(this.val$resource);
            }

            @Override
            public Map<String, Object> metadata() {
                return Map.of("josdk.resource.gvk", Controller.this.associatedGVK);
            }

            @Override
            public UpdateControl<P> execute() throws Exception {
                Controller.this.initContextIfNeeded(this.val$resource, this.val$context);
                if (!Controller.this.managedWorkflow.isEmpty()) {
                    WorkflowReconcileResult res = Controller.this.managedWorkflow.reconcile(this.val$resource, this.val$context);
                    ((DefaultManagedDependentResourceContext)this.val$context.managedDependentResourceContext()).setWorkflowExecutionResult(res);
                    res.throwAggregateExceptionIfErrorsPresent();
                }
                return Controller.this.reconciler.reconcile(this.val$resource, this.val$context);
            }
        });
    }

    @Override
    public DeleteControl cleanup(final P resource, final Context<P> context) {
        try {
            return this.metrics.timeControllerExecution(new Metrics.ControllerExecution<DeleteControl>(){

                @Override
                public String name() {
                    return Controller.CLEANUP;
                }

                @Override
                public String controllerName() {
                    return Controller.this.configuration.getName();
                }

                @Override
                public String successTypeName(DeleteControl deleteControl) {
                    return deleteControl.isRemoveFinalizer() ? Controller.DELETE : Controller.FINALIZER_NOT_REMOVED;
                }

                @Override
                public ResourceID resourceID() {
                    return ResourceID.fromResource(resource);
                }

                @Override
                public Map<String, Object> metadata() {
                    return Map.of("josdk.resource.gvk", Controller.this.associatedGVK);
                }

                @Override
                public DeleteControl execute() {
                    Controller.this.initContextIfNeeded(resource, context);
                    WorkflowCleanupResult workflowCleanupResult = null;
                    if (Controller.this.managedWorkflow.hasCleaner()) {
                        workflowCleanupResult = Controller.this.managedWorkflow.cleanup(resource, context);
                        ((DefaultManagedDependentResourceContext)context.managedDependentResourceContext()).setWorkflowCleanupResult(workflowCleanupResult);
                        workflowCleanupResult.throwAggregateExceptionIfErrorsPresent();
                    }
                    if (Controller.this.isCleaner) {
                        DeleteControl cleanupResult = ((Cleaner)((Object)Controller.this.reconciler)).cleanup(resource, context);
                        if (!cleanupResult.isRemoveFinalizer()) {
                            return cleanupResult;
                        }
                        return Controller.this.workflowCleanupResultToDefaultDelete(workflowCleanupResult);
                    }
                    return Controller.this.workflowCleanupResultToDefaultDelete(workflowCleanupResult);
                }
            });
        }
        catch (Exception e) {
            throw new OperatorException(e);
        }
    }

    private DeleteControl workflowCleanupResultToDefaultDelete(WorkflowCleanupResult workflowCleanupResult) {
        if (workflowCleanupResult == null) {
            return DeleteControl.defaultDelete();
        }
        return workflowCleanupResult.allPostConditionsMet() ? DeleteControl.defaultDelete() : DeleteControl.noFinalizerRemoval();
    }

    private void initContextIfNeeded(P resource, Context<P> context) {
        if (this.contextInitializer) {
            ((ContextInitializer)((Object)this.reconciler)).initContext(resource, context);
        }
    }

    public void initAndRegisterEventSources(EventSourceContext<P> context) {
        Map<String, DependentResource> dependentResourcesByName;
        int size;
        if (this.reconciler instanceof EventSourceInitializer) {
            EventSourceInitializer provider = (EventSourceInitializer)((Object)this.reconciler);
            Map<String, EventSource> ownSources = provider.prepareEventSources(context);
            ownSources.forEach(this.eventSourceManager::registerEventSource);
        }
        if ((size = (dependentResourcesByName = this.managedWorkflow.getDependentResourcesByNameWithoutActivationCondition()).size()) > 0) {
            dependentResourcesByName.forEach((key, dependentResource) -> {
                if (dependentResource instanceof EventSourceProvider) {
                    EventSourceProvider provider = (EventSourceProvider)((Object)dependentResource);
                    EventSource source = provider.initEventSource(context);
                    this.eventSourceManager.registerEventSource((String)key, source);
                } else {
                    Optional eventSource = dependentResource.eventSource(context);
                    eventSource.ifPresent(es -> this.eventSourceManager.registerEventSource((String)key, (EventSource)es));
                }
            });
            HashMap unresolvable = new HashMap(size);
            dependentResourcesByName.values().stream().filter(EventSourceReferencer.class::isInstance).map(EventSourceReferencer.class::cast).forEach(dr -> {
                try {
                    dr.resolveEventSource(this.eventSourceManager);
                }
                catch (EventSourceNotFoundException e) {
                    unresolvable.computeIfAbsent(e.getEventSourceName(), s -> new ArrayList()).add(dr);
                }
            });
            if (!unresolvable.isEmpty()) {
                throw new IllegalStateException("Couldn't resolve referenced EventSources: " + unresolvable);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Controller that = (Controller)o;
        return this.configuration.getName().equals(that.configuration.getName());
    }

    public int hashCode() {
        return this.configuration.getName().hashCode();
    }

    public String toString() {
        return "'" + this.configuration.getName() + "' Controller";
    }

    public Reconciler<P> getReconciler() {
        return this.reconciler;
    }

    @Override
    public ControllerConfiguration<P> getConfiguration() {
        return this.configuration;
    }

    @Override
    public ControllerHealthInfo getControllerHealthInfo() {
        return this.controllerHealthInfo;
    }

    public KubernetesClient getClient() {
        return this.kubernetesClient;
    }

    public MixedOperation<P, KubernetesResourceList<P>, Resource<P>> getCRClient() {
        return this.kubernetesClient.resources(this.configuration.getResourceClass());
    }

    @Override
    public void start() throws OperatorException {
        this.start(true);
    }

    public synchronized void start(boolean startEventProcessor) throws OperatorException {
        Class<P> resClass = this.configuration.getResourceClass();
        String controllerName = this.configuration.getName();
        String crdName = this.configuration.getResourceTypeName();
        String specVersion = "v1";
        log.info("Starting '{}' controller for reconciler: {}, resource: {}", new Object[]{controllerName, this.configuration.getAssociatedReconcilerClassName(), resClass.getCanonicalName()});
        this.failOnMissingCurrentNS();
        try {
            this.validateCRDWithLocalModelIfRequired(resClass, controllerName, crdName, "v1");
            this.eventSourceManager.start();
            if (startEventProcessor) {
                this.eventProcessor.start();
            }
            log.info("'{}' controller started", (Object)controllerName);
        }
        catch (MissingCRDException e) {
            this.stop();
            this.throwMissingCRDException(e.getCrdName(), e.getSpecVersion(), controllerName);
        }
    }

    private void validateCRDWithLocalModelIfRequired(Class<P> resClass, String controllerName, String crdName, String specVersion) {
        if (this.getConfiguration().getConfigurationService().checkCRDAndValidateLocalModel() && CustomResource.class.isAssignableFrom(resClass)) {
            CustomResourceDefinition crd = (CustomResourceDefinition)((Resource)this.kubernetesClient.apiextensions().v1().customResourceDefinitions().withName(crdName)).get();
            if (crd == null) {
                this.throwMissingCRDException(crdName, specVersion, controllerName);
            }
            CustomResourceUtils.assertCustomResource(resClass, crd);
        }
    }

    @Override
    public synchronized void changeNamespaces(Set<String> namespaces) {
        if (namespaces.contains("JOSDK_WATCH_CURRENT")) {
            throw new OperatorException("Unexpected value in target namespaces: " + namespaces);
        }
        if (namespaces.contains("JOSDK_ALL_NAMESPACES") && namespaces.size() > 1) {
            throw new OperatorException("Watching all namespaces, but additional specific namespace is present");
        }
        boolean eventProcessorWasRunning = this.eventProcessor.isRunning();
        if (eventProcessorWasRunning) {
            this.eventProcessor.stop();
        }
        this.eventSourceManager.changeNamespaces(namespaces);
        if (eventProcessorWasRunning) {
            this.eventProcessor.start();
        }
    }

    public synchronized void startEventProcessing() {
        this.eventProcessor.start();
        log.info("Started event processing for controller: {}", (Object)this.configuration.getName());
    }

    private void throwMissingCRDException(String crdName, String specVersion, String controllerName) {
        throw new MissingCRDException(crdName, specVersion, "'" + crdName + "' " + specVersion + " CRD was not found on the cluster, controller '" + controllerName + "' cannot be registered");
    }

    private void failOnMissingCurrentNS() {
        try {
            this.configuration.getEffectiveNamespaces();
        }
        catch (OperatorException e) {
            throw new OperatorException("Controller '" + this.configuration.getName() + "' is configured to watch the current namespace but it couldn't be inferred from the current configuration.");
        }
    }

    public EventSourceManager<P> getEventSourceManager() {
        return this.eventSourceManager;
    }

    @Override
    public synchronized void stop() {
        if (this.eventProcessor != null) {
            this.eventProcessor.stop();
        }
        if (this.eventSourceManager != null) {
            this.eventSourceManager.stop();
        }
    }

    public boolean useFinalizer() {
        return this.isCleaner || this.managedWorkflow.hasCleaner();
    }

    public GroupVersionKind getAssociatedGroupVersionKind() {
        return this.associatedGVK;
    }

    public EventProcessor<P> getEventProcessor() {
        return this.eventProcessor;
    }

    public ExecutorServiceManager getExecutorServiceManager() {
        return this.getConfiguration().getConfigurationService().getExecutorServiceManager();
    }

    public EventSourceContext<P> eventSourceContext() {
        return this.eventSourceContext;
    }
}

