/*
 * Decompiled with CFR 0.152.
 */
package io.javaoperatorsdk.operator.api.config;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.javaoperatorsdk.operator.api.config.BaseConfigurationService;
import io.javaoperatorsdk.operator.api.config.Cloner;
import io.javaoperatorsdk.operator.api.config.ConfigurationService;
import io.javaoperatorsdk.operator.api.config.InformerStoppedHandler;
import io.javaoperatorsdk.operator.api.config.LeaderElectionConfiguration;
import io.javaoperatorsdk.operator.api.config.ResourceClassResolver;
import io.javaoperatorsdk.operator.api.config.Utils;
import io.javaoperatorsdk.operator.api.monitoring.Metrics;
import io.javaoperatorsdk.operator.api.reconciler.dependent.DependentResourceFactory;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationServiceOverrider {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationServiceOverrider.class);
    private final ConfigurationService original;
    private Metrics metrics;
    private Boolean checkCR;
    private Integer concurrentReconciliationThreads;
    private Integer minConcurrentReconciliationThreads;
    private Integer concurrentWorkflowExecutorThreads;
    private Integer minConcurrentWorkflowExecutorThreads;
    private Cloner cloner;
    private Integer timeoutSeconds;
    private Boolean closeClientOnStop;
    private KubernetesClient client;
    private ExecutorService executorService;
    private ExecutorService workflowExecutorService;
    private LeaderElectionConfiguration leaderElectionConfiguration;
    private InformerStoppedHandler informerStoppedHandler;
    private Boolean stopOnInformerErrorDuringStartup;
    private Duration cacheSyncTimeout;
    private ResourceClassResolver resourceClassResolver;
    private Boolean ssaBasedCreateUpdateMatchForDependentResources;
    private Set<Class<? extends HasMetadata>> defaultNonSSAResource;
    private Boolean previousAnnotationForDependentResources;
    private Boolean parseResourceVersions;
    private DependentResourceFactory dependentResourceFactory;

    ConfigurationServiceOverrider(ConfigurationService original) {
        this.original = original;
    }

    public ConfigurationServiceOverrider checkingCRDAndValidateLocalModel(boolean check) {
        this.checkCR = check;
        return this;
    }

    public ConfigurationServiceOverrider withConcurrentReconciliationThreads(int threadNumber) {
        this.concurrentReconciliationThreads = threadNumber;
        return this;
    }

    public ConfigurationServiceOverrider withConcurrentWorkflowExecutorThreads(int threadNumber) {
        this.concurrentWorkflowExecutorThreads = threadNumber;
        return this;
    }

    private int minimumMaxValueFor(Integer minValue) {
        return minValue != null ? (minValue < 0 ? 0 : minValue) + 1 : 1;
    }

    public ConfigurationServiceOverrider withMinConcurrentReconciliationThreads(int threadNumber) {
        this.minConcurrentReconciliationThreads = Utils.ensureValid(threadNumber, "minimum reconciliation threads", 0, this.original.minConcurrentReconciliationThreads());
        return this;
    }

    public ConfigurationServiceOverrider withMinConcurrentWorkflowExecutorThreads(int threadNumber) {
        this.minConcurrentWorkflowExecutorThreads = Utils.ensureValid(threadNumber, "minimum workflow execution threads", 0, this.original.minConcurrentWorkflowExecutorThreads());
        return this;
    }

    public ConfigurationServiceOverrider withDependentResourceFactory(DependentResourceFactory dependentResourceFactory) {
        this.dependentResourceFactory = dependentResourceFactory;
        return this;
    }

    public ConfigurationServiceOverrider withResourceCloner(Cloner cloner) {
        this.cloner = cloner;
        return this;
    }

    public ConfigurationServiceOverrider withTerminationTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return this;
    }

    public ConfigurationServiceOverrider withMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public ConfigurationServiceOverrider withCloseClientOnStop(boolean close) {
        this.closeClientOnStop = close;
        return this;
    }

    public ConfigurationServiceOverrider withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public ConfigurationServiceOverrider withWorkflowExecutorService(ExecutorService workflowExecutorService) {
        this.workflowExecutorService = workflowExecutorService;
        return this;
    }

    public ConfigurationServiceOverrider withKubernetesClient(KubernetesClient client) {
        this.client = client;
        return this;
    }

    public ConfigurationServiceOverrider withLeaderElectionConfiguration(LeaderElectionConfiguration leaderElectionConfiguration) {
        this.leaderElectionConfiguration = leaderElectionConfiguration;
        return this;
    }

    public ConfigurationServiceOverrider withInformerStoppedHandler(InformerStoppedHandler handler) {
        this.informerStoppedHandler = handler;
        return this;
    }

    public ConfigurationServiceOverrider withStopOnInformerErrorDuringStartup(boolean stopOnInformerErrorDuringStartup) {
        this.stopOnInformerErrorDuringStartup = stopOnInformerErrorDuringStartup;
        return this;
    }

    public ConfigurationServiceOverrider withCacheSyncTimeout(Duration cacheSyncTimeout) {
        this.cacheSyncTimeout = cacheSyncTimeout;
        return this;
    }

    public ConfigurationServiceOverrider withResourceClassResolver(ResourceClassResolver resourceClassResolver) {
        this.resourceClassResolver = resourceClassResolver;
        return this;
    }

    public ConfigurationServiceOverrider withSSABasedCreateUpdateMatchForDependentResources(boolean value) {
        this.ssaBasedCreateUpdateMatchForDependentResources = value;
        return this;
    }

    public ConfigurationServiceOverrider withDefaultNonSSAResource(Set<Class<? extends HasMetadata>> defaultNonSSAResource) {
        this.defaultNonSSAResource = defaultNonSSAResource;
        return this;
    }

    public ConfigurationServiceOverrider withPreviousAnnotationForDependentResources(boolean value) {
        this.previousAnnotationForDependentResources = value;
        return this;
    }

    public ConfigurationServiceOverrider wihtParseResourceVersions(boolean value) {
        this.parseResourceVersions = value;
        return this;
    }

    public ConfigurationService build() {
        return new BaseConfigurationService(this.original.getVersion(), this.cloner, this.client){

            @Override
            public Set<String> getKnownReconcilerNames() {
                return ConfigurationServiceOverrider.this.original.getKnownReconcilerNames();
            }

            @Override
            public boolean checkCRDAndValidateLocalModel() {
                return ConfigurationServiceOverrider.this.checkCR != null ? ConfigurationServiceOverrider.this.checkCR.booleanValue() : ConfigurationServiceOverrider.this.original.checkCRDAndValidateLocalModel();
            }

            @Override
            public DependentResourceFactory dependentResourceFactory() {
                return ConfigurationServiceOverrider.this.dependentResourceFactory != null ? ConfigurationServiceOverrider.this.dependentResourceFactory : DependentResourceFactory.DEFAULT;
            }

            @Override
            public int concurrentReconciliationThreads() {
                return Utils.ensureValid(ConfigurationServiceOverrider.this.concurrentReconciliationThreads != null ? ConfigurationServiceOverrider.this.concurrentReconciliationThreads.intValue() : ConfigurationServiceOverrider.this.original.concurrentReconciliationThreads(), "maximum reconciliation threads", ConfigurationServiceOverrider.this.minimumMaxValueFor(ConfigurationServiceOverrider.this.minConcurrentReconciliationThreads), ConfigurationServiceOverrider.this.original.concurrentReconciliationThreads());
            }

            @Override
            public int concurrentWorkflowExecutorThreads() {
                return Utils.ensureValid(ConfigurationServiceOverrider.this.concurrentWorkflowExecutorThreads != null ? ConfigurationServiceOverrider.this.concurrentWorkflowExecutorThreads.intValue() : ConfigurationServiceOverrider.this.original.concurrentWorkflowExecutorThreads(), "maximum workflow execution threads", ConfigurationServiceOverrider.this.minimumMaxValueFor(ConfigurationServiceOverrider.this.minConcurrentWorkflowExecutorThreads), ConfigurationServiceOverrider.this.original.concurrentWorkflowExecutorThreads());
            }

            @Override
            @Deprecated(forRemoval=true)
            public int minConcurrentReconciliationThreads() {
                return ConfigurationServiceOverrider.this.minConcurrentReconciliationThreads != null ? ConfigurationServiceOverrider.this.minConcurrentReconciliationThreads.intValue() : ConfigurationServiceOverrider.this.original.minConcurrentReconciliationThreads();
            }

            @Override
            @Deprecated(forRemoval=true)
            public int minConcurrentWorkflowExecutorThreads() {
                return ConfigurationServiceOverrider.this.minConcurrentWorkflowExecutorThreads != null ? ConfigurationServiceOverrider.this.minConcurrentWorkflowExecutorThreads.intValue() : ConfigurationServiceOverrider.this.original.minConcurrentWorkflowExecutorThreads();
            }

            @Override
            public int getTerminationTimeoutSeconds() {
                return ConfigurationServiceOverrider.this.timeoutSeconds != null ? ConfigurationServiceOverrider.this.timeoutSeconds.intValue() : ConfigurationServiceOverrider.this.original.getTerminationTimeoutSeconds();
            }

            @Override
            public Metrics getMetrics() {
                return ConfigurationServiceOverrider.this.metrics != null ? ConfigurationServiceOverrider.this.metrics : ConfigurationServiceOverrider.this.original.getMetrics();
            }

            @Override
            public boolean closeClientOnStop() {
                return ConfigurationServiceOverrider.this.closeClientOnStop != null ? ConfigurationServiceOverrider.this.closeClientOnStop.booleanValue() : ConfigurationServiceOverrider.this.original.closeClientOnStop();
            }

            @Override
            public ExecutorService getExecutorService() {
                return ConfigurationServiceOverrider.this.executorService != null ? ConfigurationServiceOverrider.this.executorService : super.getExecutorService();
            }

            @Override
            public ExecutorService getWorkflowExecutorService() {
                return ConfigurationServiceOverrider.this.workflowExecutorService != null ? ConfigurationServiceOverrider.this.workflowExecutorService : super.getWorkflowExecutorService();
            }

            @Override
            public Optional<LeaderElectionConfiguration> getLeaderElectionConfiguration() {
                return ConfigurationServiceOverrider.this.leaderElectionConfiguration != null ? Optional.of(ConfigurationServiceOverrider.this.leaderElectionConfiguration) : ConfigurationServiceOverrider.this.original.getLeaderElectionConfiguration();
            }

            @Override
            public Optional<InformerStoppedHandler> getInformerStoppedHandler() {
                return ConfigurationServiceOverrider.this.informerStoppedHandler != null ? Optional.of(ConfigurationServiceOverrider.this.informerStoppedHandler) : ConfigurationServiceOverrider.this.original.getInformerStoppedHandler();
            }

            @Override
            public boolean stopOnInformerErrorDuringStartup() {
                return ConfigurationServiceOverrider.this.stopOnInformerErrorDuringStartup != null ? ConfigurationServiceOverrider.this.stopOnInformerErrorDuringStartup.booleanValue() : super.stopOnInformerErrorDuringStartup();
            }

            @Override
            public Duration cacheSyncTimeout() {
                return ConfigurationServiceOverrider.this.cacheSyncTimeout != null ? ConfigurationServiceOverrider.this.cacheSyncTimeout : super.cacheSyncTimeout();
            }

            @Override
            public ResourceClassResolver getResourceClassResolver() {
                return ConfigurationServiceOverrider.this.resourceClassResolver != null ? ConfigurationServiceOverrider.this.resourceClassResolver : super.getResourceClassResolver();
            }

            @Override
            public boolean ssaBasedCreateUpdateMatchForDependentResources() {
                return ConfigurationServiceOverrider.this.ssaBasedCreateUpdateMatchForDependentResources != null ? ConfigurationServiceOverrider.this.ssaBasedCreateUpdateMatchForDependentResources.booleanValue() : super.ssaBasedCreateUpdateMatchForDependentResources();
            }

            @Override
            public Set<Class<? extends HasMetadata>> defaultNonSSAResource() {
                return ConfigurationServiceOverrider.this.defaultNonSSAResource != null ? ConfigurationServiceOverrider.this.defaultNonSSAResource : super.defaultNonSSAResource();
            }

            @Override
            public boolean previousAnnotationForDependentResourcesEventFiltering() {
                return ConfigurationServiceOverrider.this.previousAnnotationForDependentResources != null ? ConfigurationServiceOverrider.this.previousAnnotationForDependentResources.booleanValue() : super.previousAnnotationForDependentResourcesEventFiltering();
            }

            @Override
            public boolean parseResourceVersionsForEventFilteringAndCaching() {
                return ConfigurationServiceOverrider.this.parseResourceVersions != null ? ConfigurationServiceOverrider.this.parseResourceVersions.booleanValue() : super.parseResourceVersionsForEventFilteringAndCaching();
            }
        };
    }

    @Deprecated(since="2.2.0")
    public static ConfigurationServiceOverrider override(ConfigurationService original) {
        return new ConfigurationServiceOverrider(original);
    }
}

