/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.operator.core.dependent;

import io.debezium.operator.api.model.CommonLabels;
import io.debezium.operator.api.model.DebeziumServer;
import io.debezium.operator.core.dependent.discriminators.JmxExporterServiceDiscriminator;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.kubernetes.api.model.ServiceSpecBuilder;
import io.javaoperatorsdk.operator.api.reconciler.Context;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.CRUDKubernetesDependentResource;
import io.javaoperatorsdk.operator.processing.dependent.kubernetes.KubernetesDependent;
import java.util.Map;

@KubernetesDependent(resourceDiscriminator=JmxExporterServiceDiscriminator.class)
public class JmxExporterServiceDependent
extends CRUDKubernetesDependentResource<Service, DebeziumServer> {
    public static final String JMX_EXPORTER_CLASSIFIER = "jmx-exporter";

    public JmxExporterServiceDependent() {
        super(Service.class);
    }

    protected Service desired(DebeziumServer primary, Context<DebeziumServer> context) {
        String name = primary.getMetadata().getName();
        Map labels = CommonLabels.serverComponent((String)name).withDbzClassifier(JMX_EXPORTER_CLASSIFIER).getMap();
        Map selector = CommonLabels.serverComponent((String)name).getMap();
        return ((ServiceBuilder)((ServiceBuilder)new ServiceBuilder().withMetadata(((ObjectMetaBuilder)((ObjectMetaBuilder)((ObjectMetaBuilder)new ObjectMetaBuilder().withNamespace(primary.getMetadata().getNamespace())).withName(name + "exporter-metrics")).withLabels(labels)).build())).withSpec(((ServiceSpecBuilder)((ServiceSpecBuilder)new ServiceSpecBuilder().withSelector(selector)).withPorts(new ServicePort[]{((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName("metrics-jmx")).withProtocol("TCP")).withTargetPort(new IntOrString((Object)9090))).withPort(Integer.valueOf(9090))).build()})).build())).build();
    }
}

